/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface FileManager {
    public static final String INDEXING_QUERY = "    ";
    public static final String BROWSE_QUERY = "*.*";
    public static final List<LimeXMLDocument> EMPTY_DOCUMENTS = Collections.emptyList();
    public static final String DELIMITERS = " -._+/*()\\,";

    public void start();

    public void startAndWait(long var1) throws InterruptedException, TimeoutException;

    public void stop();

    public int getSize();

    public int getNumFiles();

    public int getNumStoreFiles();

    public int getNumIncompleteFiles();

    public int getNumPendingFiles();

    public int getNumForcedFiles();

    public FileDesc get(int var1);

    public boolean isValidSharedIndex(int var1);

    public URN getURNForFile(File var1);

    public FileDesc getFileDescForFile(File var1);

    public boolean isUrnShared(URN var1);

    public FileDesc getFileDescForUrn(URN var1);

    public FileDesc getSharedFileDescForUrn(URN var1);

    public FileDesc[] getIncompleteFileDescriptors();

    public FileDesc[] getAllSharedFileDescriptors();

    public List<FileDesc> getSharedFilesInDirectory(File var1);

    public void loadSettings();

    public void loadSettingsAndWait(long var1) throws InterruptedException, TimeoutException;

    public void loadWithNewDirectories(Set<? extends File> var1, Set<File> var2);

    public boolean isLoadFinished();

    public boolean isUpdating();

    public void removeFolderIfShared(File var1);

    public void addSharedFolders(Set<File> var1, Set<File> var2);

    public Set<File> getFolderNotToShare();

    public boolean addSharedFolder(File var1);

    public void addFileAlways(File var1);

    public void addFileAlways(File var1, FileEventListener var2);

    public void addFileAlways(File var1, List<? extends LimeXMLDocument> var2);

    public void addFileAlways(File var1, List<? extends LimeXMLDocument> var2, FileEventListener var3);

    public void addFileForSession(File var1);

    public void addFileForSession(File var1, FileEventListener var2);

    public void addFileIfShared(File var1);

    public void addFileIfShared(File var1, FileEventListener var2);

    public void addFileIfShared(File var1, List<? extends LimeXMLDocument> var2);

    public void addFileIfShared(File var1, List<? extends LimeXMLDocument> var2, FileEventListener var3);

    public FileDesc stopSharingFile(File var1);

    public FileDesc removeFileIfSharedOrStore(File var1);

    public void addIncompleteFile(File var1, Set<? extends URN> var2, String var3, long var4, VerifyingFile var6);

    public void fileChanged(File var1);

    public void validate(FileDesc var1);

    public void renameFileIfSharedOrStore(File var1, File var2);

    public void renameFileIfSharedOrStore(File var1, File var2, FileEventListener var3);

    public void validateSensitiveFile(File var1);

    public void invalidateSensitiveFile(File var1);

    public boolean hasIndividualFiles();

    public boolean hasIndividualStoreFiles();

    public File[] getIndividualFiles();

    public File[] getIndividualStoreFiles();

    public boolean isIndividualStore(File var1);

    public boolean isIndividualShare(File var1);

    public boolean isFileShared(File var1);

    public boolean isRareFile(FileDesc var1);

    public boolean isFileInCompletelySharedDirectory(File var1);

    public boolean isFolderShared(File var1);

    public boolean isStoreFileLoaded(File var1);

    public boolean isStoreDirectory(File var1);

    public boolean isFolderShareable(File var1, boolean var2);

    public QueryRouteTable getQRT();

    public Response[] query(QueryRequest var1);

    public void addFileEventListener(FileEventListener var1);

    public void removeFileEventListener(FileEventListener var1);

    public Iterator<Response> getIndexingIterator(boolean var1);

    public void fileURNSUpdated(FileDesc var1);
}

