/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.routing.HashFunction;
import com.limegroup.gnutella.settings.DHTSettings;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.limewire.util.I18NConvert;
import org.limewire.util.RPNParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDesc
implements RPNParser.StringLookup {
    private final int _index;
    private final String _path;
    private final String _name;
    private final long _size;
    private long _modTime;
    private volatile Set<URN> URNS;
    private final File FILE;
    private final URN SHA1_URN;
    private License _license;
    private final List<LimeXMLDocument> _limeXMLDocs = new CopyOnWriteArrayList<LimeXMLDocument>();
    private int _hits;
    private int _attemptedUploads;
    private long lastAttemptedUploadTime = System.currentTimeMillis();
    private int _completedUploads;

    protected FileDesc() {
        this.SHA1_URN = null;
        this._size = -1L;
        this._name = null;
        this.FILE = null;
        this._index = -1;
        this.URNS = null;
        this._path = null;
    }

    public FileDesc(File file, Set<? extends URN> set, int n) {
        if (file == null) {
            throw new NullPointerException("cannot create a FileDesc with a null File");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("negative index (" + n + ") not permitted in FileDesc");
        }
        if (set == null) {
            throw new NullPointerException("cannot create a FileDesc with a null URN Set");
        }
        this.FILE = file;
        this._index = n;
        this._name = I18NConvert.instance().compose(this.FILE.getName());
        this._path = this.FILE.getAbsolutePath();
        this._size = this.FILE.length();
        assert (this._size >= 0L && this._size <= 0xFFFFFFFFFFL) : "invalid size " + this._size + " of file " + this.FILE;
        this._modTime = this.FILE.lastModified();
        this.URNS = Collections.unmodifiableSet(set);
        this.SHA1_URN = this.extractSHA1();
        if (this.SHA1_URN == null) {
            throw new IllegalArgumentException("no SHA1 URN");
        }
        this._hits = 0;
    }

    public boolean hasUrns() {
        return !this.URNS.isEmpty();
    }

    public int getIndex() {
        return this._index;
    }

    public long getFileSize() {
        return this._size;
    }

    public String getFileName() {
        return this._name;
    }

    public long lastModified() {
        return this._modTime;
    }

    private URN extractSHA1() {
        for (URN uRN : this.URNS) {
            if (!uRN.isSHA1()) continue;
            return uRN;
        }
        return null;
    }

    public URN getTTROOTUrn() {
        for (URN uRN : this.URNS) {
            if (!uRN.isTTRoot()) continue;
            return uRN;
        }
        return null;
    }

    public File getFile() {
        return this.FILE;
    }

    public URN getSHA1Urn() {
        return this.SHA1_URN;
    }

    public boolean setTTRoot(URN uRN) {
        boolean bl = !this.getUrns().contains(uRN);
        UrnSet urnSet = new UrnSet();
        urnSet.add(this.SHA1_URN);
        urnSet.add(uRN);
        this.URNS = Collections.unmodifiableSet(urnSet);
        return bl;
    }

    public Set<URN> getUrns() {
        return this.URNS;
    }

    public String getPath() {
        return this.FILE.getAbsolutePath();
    }

    public void addLimeXMLDocument(LimeXMLDocument limeXMLDocument) {
        this._limeXMLDocs.add(limeXMLDocument);
        limeXMLDocument.initIdentifier(this.FILE);
        if (limeXMLDocument.isLicenseAvailable()) {
            this._license = limeXMLDocument.getLicense();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceLimeXMLDocument(LimeXMLDocument limeXMLDocument, LimeXMLDocument limeXMLDocument2) {
        List<LimeXMLDocument> list = this._limeXMLDocs;
        synchronized (list) {
            int n = this._limeXMLDocs.indexOf(limeXMLDocument);
            if (n == -1) {
                return false;
            }
            this._limeXMLDocs.set(n, limeXMLDocument2);
        }
        limeXMLDocument2.initIdentifier(this.FILE);
        if (limeXMLDocument2.isLicenseAvailable()) {
            this._license = limeXMLDocument2.getLicense();
        } else if (this._license != null && limeXMLDocument.isLicenseAvailable()) {
            this._license = null;
        }
        return true;
    }

    public boolean removeLimeXMLDocument(LimeXMLDocument limeXMLDocument) {
        if (!this._limeXMLDocs.remove(limeXMLDocument)) {
            return false;
        }
        if (this._license != null && limeXMLDocument.isLicenseAvailable()) {
            this._license = null;
        }
        return true;
    }

    public List<LimeXMLDocument> getLimeXMLDocuments() {
        return this._limeXMLDocs;
    }

    public LimeXMLDocument getXMLDocument() {
        List<LimeXMLDocument> list = this.getLimeXMLDocuments();
        return list.isEmpty() ? null : list.get(0);
    }

    public LimeXMLDocument getXMLDocument(String string) {
        for (LimeXMLDocument limeXMLDocument : this.getLimeXMLDocuments()) {
            if (!limeXMLDocument.getSchemaURI().equalsIgnoreCase(string)) continue;
            return limeXMLDocument;
        }
        return null;
    }

    public boolean isLicensed() {
        return this._license != null;
    }

    public License getLicense() {
        return this._license;
    }

    public boolean containsUrn(URN uRN) {
        return this.URNS.contains(uRN);
    }

    public int incrementHitCount() {
        return ++this._hits;
    }

    public int getHitCount() {
        return this._hits;
    }

    public synchronized int incrementAttemptedUploads() {
        this.lastAttemptedUploadTime = System.currentTimeMillis();
        return ++this._attemptedUploads;
    }

    public synchronized int getAttemptedUploads() {
        return this._attemptedUploads;
    }

    public synchronized long getLastAttemptedUploadTime() {
        return this.lastAttemptedUploadTime;
    }

    public int incrementCompletedUploads() {
        return ++this._completedUploads;
    }

    public int getCompletedUploads() {
        return this._completedUploads;
    }

    public String toString() {
        return "FileDesc:\r\nname:     " + this._name + "\r\n" + "index:    " + this._index + "\r\n" + "path:     " + this._path + "\r\n" + "size:     " + this._size + "\r\n" + "modTime:  " + this._modTime + "\r\n" + "File:     " + this.FILE + "\r\n" + "urns:     " + this.URNS + "\r\n" + "docs:     " + this._limeXMLDocs + "\r\n";
    }

    @Override
    public String lookup(String string) {
        if (string == null) {
            return null;
        }
        if ("hits".equals(string)) {
            return String.valueOf(this.getHitCount());
        }
        if ("ups".equals(string)) {
            return String.valueOf(this.getAttemptedUploads());
        }
        if ("cups".equals(string)) {
            return String.valueOf(this.getCompletedUploads());
        }
        if ("lastup".equals(string)) {
            return String.valueOf(System.currentTimeMillis() - this.getLastAttemptedUploadTime());
        }
        if ("licensed".equals(string)) {
            return String.valueOf(this.isLicensed());
        }
        if ("atUpSet".equals(string)) {
            return DHTSettings.RARE_FILE_ATTEMPTED_UPLOADS.getValueAsString();
        }
        if ("cUpSet".equals(string)) {
            return DHTSettings.RARE_FILE_COMPLETED_UPLOADS.getValueAsString();
        }
        if ("rftSet".equals(string)) {
            return DHTSettings.RARE_FILE_TIME.getValueAsString();
        }
        if ("hasXML".equals(string)) {
            return String.valueOf(this.getXMLDocument() != null);
        }
        if ("size".equals(string)) {
            return String.valueOf(this._size);
        }
        if ("lastM".equals(string)) {
            return String.valueOf(this.lastModified());
        }
        if ("numKW".equals(string)) {
            return String.valueOf(HashFunction.keywords(this.getPath()).length);
        }
        if ("numKWP".equals(string)) {
            return String.valueOf(HashFunction.getPrefixes(HashFunction.keywords(this.getPath())).length);
        }
        if (string.startsWith("xml_") && this.getXMLDocument() != null) {
            string = string.substring(4, string.length());
            return this.getXMLDocument().lookup(string);
        }
        return null;
    }
}

