/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.util.ByteUtils;
import org.limewire.util.StringUtils;

public class Endpoint
implements Cloneable,
Connectable,
IpPort,
Serializable {
    private static final long serialVersionUID = 4686711693494625070L;
    private volatile InetAddress addr = null;
    private volatile String hostname = null;
    private volatile int port = 0;
    private volatile long files = -1L;
    private volatile long kbytes = -1L;

    protected Endpoint() {
    }

    public Endpoint(String string) throws IllegalArgumentException {
        this(string, false);
    }

    public Endpoint(String string, boolean bl) {
        this(string, bl, true);
    }

    public Endpoint(String string, boolean bl, boolean bl2) {
        int n = string.indexOf(":");
        if (n < 0) {
            this.hostname = string;
            this.port = 6346;
        } else {
            if (n == 0) {
                throw new IllegalArgumentException();
            }
            if (n == string.length() - 1) {
                this.hostname = string.substring(0, n);
                this.port = 6346;
            } else {
                this.hostname = string.substring(0, n);
                try {
                    this.port = Integer.parseInt(string.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException();
                }
                if (!NetworkUtils.isValidPort(this.getPort())) {
                    throw new IllegalArgumentException("invalid port");
                }
            }
        }
        if (bl) {
            String[] stringArray = StringUtils.split(this.hostname, '.');
            if (stringArray.length != 4) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    int n2 = Integer.parseInt(stringArray[i]);
                    if (n2 >= 0 && n2 <= 255) continue;
                    throw new IllegalArgumentException();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (bl2 && !NetworkUtils.isValidAddress(this.hostname)) {
            throw new IllegalArgumentException("invalid address: " + this.hostname);
        }
    }

    public Endpoint(String string, int n) {
        this(string, n, true);
    }

    public Endpoint(InetAddress inetAddress, int n) {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (!NetworkUtils.isValidAddress(inetAddress)) {
            throw new IllegalArgumentException("invalid address: " + inetAddress);
        }
        this.addr = inetAddress;
        this.hostname = inetAddress.getHostAddress();
        this.port = n;
    }

    public Endpoint(String string, int n, boolean bl) {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (bl && !NetworkUtils.isValidAddress(string)) {
            throw new IllegalArgumentException("invalid address: " + string);
        }
        this.hostname = string;
        this.port = n;
    }

    public Endpoint(byte[] byArray, int n) {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (!NetworkUtils.isValidAddress(byArray)) {
            throw new IllegalArgumentException("invalid address");
        }
        this.port = n;
        this.hostname = NetworkUtils.ip2string(byArray);
    }

    public Endpoint(String string, int n, long l, long l2) {
        this(string, n);
        this.files = l;
        this.kbytes = l2;
    }

    public Endpoint(byte[] byArray, int n, long l, long l2) {
        this(byArray, n);
        this.files = l;
        this.kbytes = l2;
    }

    public Endpoint(Endpoint endpoint) {
        this.files = endpoint.files;
        this.hostname = endpoint.hostname;
        this.kbytes = endpoint.kbytes;
        this.port = endpoint.port;
    }

    public String toString() {
        return this.hostname + ":" + this.port;
    }

    public String getAddress() {
        return this.hostname;
    }

    public InetAddress getInetAddress() {
        if (this.addr != null) {
            return this.addr;
        }
        try {
            this.addr = InetAddress.getByName(this.hostname);
            return this.addr;
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public void setHostname(String string) {
        this.hostname = string;
        this.addr = null;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress getInetSocketAddress() {
        InetAddress inetAddress = this.getInetAddress();
        if (inetAddress == null) {
            return null;
        }
        return new InetSocketAddress(inetAddress, this.getPort());
    }

    public long getFiles() {
        return this.files;
    }

    public void setFiles(long l) {
        this.files = l;
    }

    public long getKbytes() {
        return this.kbytes;
    }

    public void normalizeFilesAndSize() {
        try {
            if (this.kbytes > 20000000L) {
                this.kbytes = 0L;
                this.files = 0L;
                return;
            }
            if (this.files > 5000L) {
                this.kbytes = 0L;
                this.files = 0L;
                return;
            }
            if (this.kbytes / this.files > 250000L) {
                this.kbytes = 0L;
                this.files = 0L;
                return;
            }
        }
        catch (ArithmeticException arithmeticException) {
            this.kbytes = 0L;
            this.files = 0L;
            return;
        }
    }

    public void setKbytes(long l) {
        this.kbytes = l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Endpoint)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Endpoint endpoint = (Endpoint)object;
        return this.hostname.equals(endpoint.hostname) && this.port == endpoint.port;
    }

    public int hashCode() {
        return this.hostname.hashCode();
    }

    protected Object clone() {
        return new Endpoint(new String(this.hostname), this.port, this.files, this.kbytes);
    }

    public byte[] getHostBytes() throws UnknownHostException {
        InetAddress inetAddress = this.getInetAddress();
        if (inetAddress == null) {
            throw new UnknownHostException(this.hostname);
        }
        return inetAddress.getAddress();
    }

    public boolean isSameSubnet(Endpoint endpoint) {
        byte[] byArray;
        int n;
        byte[] byArray2;
        try {
            byArray2 = this.getHostBytes();
            n = ByteUtils.ubyte2int(byArray2[0]);
            byArray = endpoint.getHostBytes();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        if (n <= 127) {
            return byArray2[0] == byArray[0];
        }
        if (n <= 191) {
            return byArray2[0] == byArray[0] && byArray2[1] == byArray[1];
        }
        return byArray2[0] == byArray[0] && byArray2[1] == byArray[1] && byArray2[2] == byArray[2];
    }

    public boolean isUDPHostCache() {
        return false;
    }

    public boolean isTLSCapable() {
        return false;
    }
}

