/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.DownloadServices;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.downloader.CantResumeException;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DownloadServicesImpl
implements DownloadServices {
    private final Provider<DownloadManager> downloadManager;

    @Inject
    public DownloadServicesImpl(Provider<DownloadManager> provider) {
        this.downloadManager = provider;
    }

    @Override
    public Downloader download(File file) throws CantResumeException, SaveLocationException {
        return ((DownloadManager)this.downloadManager.get()).download(file);
    }

    @Override
    public Downloader download(RemoteFileDesc[] remoteFileDescArray, boolean bl, GUID gUID) throws SaveLocationException {
        return this.download(remoteFileDescArray, gUID, bl, null, null);
    }

    @Override
    public Downloader download(RemoteFileDesc[] remoteFileDescArray, GUID gUID, boolean bl, File file, String string) throws SaveLocationException {
        return this.download(remoteFileDescArray, RemoteFileDesc.EMPTY_LIST, gUID, bl, file, string);
    }

    @Override
    public Downloader download(RemoteFileDesc[] remoteFileDescArray, List<? extends RemoteFileDesc> list, GUID gUID, boolean bl) throws SaveLocationException {
        return this.download(remoteFileDescArray, list, gUID, bl, null, null);
    }

    @Override
    public Downloader download(RemoteFileDesc[] remoteFileDescArray, List<? extends RemoteFileDesc> list, GUID gUID, boolean bl, File file, String string) throws SaveLocationException {
        return ((DownloadManager)this.downloadManager.get()).download(remoteFileDescArray, list, gUID, bl, file, string);
    }

    @Override
    public int getNumActiveDownloads() {
        return ((DownloadManager)this.downloadManager.get()).getNumActiveDownloads();
    }

    @Override
    public int getNumDownloads() {
        return ((DownloadManager)this.downloadManager.get()).downloadsInProgress();
    }

    @Override
    public boolean hasActiveDownloads() {
        ((DownloadManager)this.downloadManager.get()).measureBandwidth();
        return ((DownloadManager)this.downloadManager.get()).getMeasuredBandwidth() != 0.0f;
    }
}

