/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.QueryRequest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Comparators;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.io.IOUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.ConverterObjectInputStream;
import org.limewire.util.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class CreationTimeCache {
    private static final Log LOG = LogFactory.getLog(CreationTimeCache.class);
    private static final File CTIME_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "createtimes.cache");
    private volatile boolean dirty = false;
    private final ExecutorService deserializeQueue = ExecutorsHelper.newProcessingQueue("CreationTimeCacheDeserializer");
    private final FileManager fileManager;
    private final Future<Maps> deserializer;

    @Inject
    CreationTimeCache(FileManager fileManager) {
        this.fileManager = fileManager;
        this.deserializer = this.deserializeQueue.submit(new Callable<Maps>(){

            @Override
            public Maps call() throws Exception {
                Map<URN, Long> map = CreationTimeCache.this.createMap();
                SortedMap sortedMap = CreationTimeCache.this.constructURNMap(map);
                return new Maps(map, sortedMap);
            }
        });
    }

    Map<URN, Long> getUrnToTime() {
        return this.getMaps().getUrnToTime();
    }

    SortedMap<Long, Set<URN>> getTimeToUrn() {
        return this.getMaps().getTimeToUrn();
    }

    private Maps getMaps() {
        boolean bl = false;
        while (true) {
            try {
                Maps maps = this.deserializer.get();
                return maps;
            }
            catch (InterruptedException interruptedException) {
                try {
                    bl = true;
                    continue;
                }
                catch (ExecutionException executionException) {
                    throw new RuntimeException(executionException);
                }
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized int getSize() {
        return this.getUrnToTime().size();
    }

    public synchronized Long getCreationTime(URN uRN) {
        return this.getUrnToTime().get(uRN);
    }

    public long getCreationTimeAsLong(URN uRN) {
        Long l = this.getCreationTime(uRN);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public synchronized void removeTime(URN uRN) {
        Long l = this.getUrnToTime().remove(uRN);
        this.removeURNFromURNSet(uRN, l);
        if (l != null) {
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneTimes(boolean bl) {
        FileManager fileManager = this.fileManager;
        synchronized (fileManager) {
            CreationTimeCache creationTimeCache = this;
            synchronized (creationTimeCache) {
                Iterator<Map.Entry<URN, Long>> iterator = this.getUrnToTime().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<URN, Long> entry = iterator.next();
                    URN uRN = entry.getKey();
                    Long l = entry.getValue();
                    FileDesc fileDesc = this.fileManager.getFileDescForUrn(uRN);
                    if (fileDesc != null && fileDesc.getFile() != null && fileDesc.getFile().exists()) continue;
                    this.dirty = true;
                    iterator.remove();
                    if (!bl) continue;
                    this.removeURNFromURNSet(uRN, l);
                }
            }
        }
    }

    public void pruneTimes() {
        this.pruneTimes(true);
    }

    public synchronized void addTime(URN uRN, long l) throws IllegalArgumentException {
        if (uRN == null) {
            throw new IllegalArgumentException("Null URN.");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("Bad Time = " + l);
        }
        Long l2 = new Long(l);
        Long l3 = this.getUrnToTime().get(uRN);
        if (l3 == null || !l3.equals(l2)) {
            this.dirty = true;
            this.getUrnToTime().put(uRN, l2);
        }
    }

    public synchronized void commitTime(URN uRN) throws IllegalArgumentException {
        if (uRN == null) {
            throw new IllegalArgumentException("Null URN.");
        }
        Long l = this.getUrnToTime().get(uRN);
        if (l == null) {
            throw new IllegalArgumentException("Never added URN via addTime()");
        }
        HashSet<URN> hashSet = (HashSet<URN>)this.getTimeToUrn().get(l);
        if (hashSet == null) {
            hashSet = new HashSet<URN>();
            this.getTimeToUrn().put(l, hashSet);
        }
        hashSet.add(uRN);
    }

    public List<URN> getFiles(int n) throws IllegalArgumentException {
        return this.getFiles(null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<URN> getFiles(QueryRequest queryRequest, int n) throws IllegalArgumentException {
        FileManager fileManager = this.fileManager;
        synchronized (fileManager) {
            CreationTimeCache creationTimeCache = this;
            synchronized (creationTimeCache) {
                if (n < 1) {
                    throw new IllegalArgumentException("bad max = " + n);
                }
                MediaType.Aggregator aggregator = queryRequest == null ? null : MediaType.getAggregator(queryRequest);
                ArrayList<URN> arrayList = null;
                ArrayList<URN> arrayList2 = new ArrayList<URN>();
                block6: for (Set<URN> object : this.getTimeToUrn().values()) {
                    if (arrayList2.size() >= n) break;
                    for (URN uRN : object) {
                        if (arrayList2.size() >= n) continue block6;
                        FileDesc fileDesc = this.fileManager.getFileDescForUrn(uRN);
                        if (fileDesc != null && this.fileManager.isStoreFileLoaded(fileDesc.getFile())) continue;
                        if (fileDesc == null || fileDesc instanceof IncompleteFileDesc) {
                            if (arrayList == null) {
                                arrayList = new ArrayList<URN>();
                            }
                            arrayList.add(uRN);
                            continue;
                        }
                        if (aggregator == null) {
                            arrayList2.add(uRN);
                            continue;
                        }
                        if (!aggregator.allow(fileDesc.getFileName())) continue;
                        arrayList2.add(uRN);
                    }
                }
                if (arrayList != null) {
                    for (URN uRN : arrayList) {
                        this.removeTime(uRN);
                    }
                }
                return arrayList2;
            }
        }
    }

    public List<URN> getFiles() {
        return this.getFiles(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistCache() {
        if (!this.dirty) {
            return;
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(CTIME_CACHE_FILE)));
            objectOutputStream.writeObject(this.getUrnToTime());
            IOUtils.close(objectOutputStream);
        }
        catch (IOException iOException) {
            LOG.error((Object)"Unable to write creation cache", (Throwable)iOException);
        }
        finally {
            IOUtils.close(objectOutputStream);
        }
        this.dirty = false;
    }

    private synchronized void removeURNFromURNSet(URN uRN, Long l) {
        block2: {
            block1: {
                if (l == null) break block1;
                Set set = (Set)this.getTimeToUrn().get(l);
                if (set == null || !set.remove(uRN) || set.size() >= 1) break block2;
                this.getTimeToUrn().remove(l);
                break block2;
            }
            Iterator<Set<URN>> iterator = this.getTimeToUrn().values().iterator();
            while (iterator.hasNext()) {
                Set<URN> set = iterator.next();
                if (!set.contains(uRN)) continue;
                set.remove(uRN);
                if (set.size() >= 1) break;
                iterator.remove();
                break;
            }
        }
    }

    private SortedMap<Long, Set<URN>> constructURNMap(Map<URN, Long> map) {
        TreeMap<Long, Set<URN>> treeMap = new TreeMap<Long, Set<URN>>(Comparators.inverseLongComparator());
        for (Map.Entry<URN, Long> entry : map.entrySet()) {
            Long l = entry.getValue();
            URN uRN = entry.getKey();
            HashSet<URN> hashSet = (HashSet<URN>)treeMap.get(l);
            if (hashSet == null) {
                hashSet = new HashSet<URN>();
                treeMap.put(l, hashSet);
            }
            hashSet.add(uRN);
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<URN, Long> createMap() {
        Map<URN, Long> map;
        if (!CTIME_CACHE_FILE.exists()) {
            this.dirty = true;
            return new HashMap<URN, Long>();
        }
        ConverterObjectInputStream converterObjectInputStream = null;
        try {
            Map<URN, Long> map2;
            converterObjectInputStream = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(CTIME_CACHE_FILE)));
            map = map2 = GenericsUtils.scanForMap(converterObjectInputStream.readObject(), URN.class, Long.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable throwable) {
            HashMap<URN, Long> hashMap;
            try {
                this.dirty = true;
                LOG.error((Object)"Unable to read creation time file", throwable);
                hashMap = new HashMap<URN, Long>();
            }
            catch (Throwable throwable2) {
                IOUtils.close(converterObjectInputStream);
                throw throwable2;
            }
            IOUtils.close(converterObjectInputStream);
            return hashMap;
        }
        IOUtils.close(converterObjectInputStream);
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Maps {
        private final Map<URN, Long> urnToTime;
        private final SortedMap<Long, Set<URN>> timeToUrn;

        Maps(Map<URN, Long> map, SortedMap<Long, Set<URN>> sortedMap) {
            this.urnToTime = map;
            this.timeToUrn = sortedMap;
        }

        public SortedMap<Long, Set<URN>> getTimeToUrn() {
            return this.timeToUrn;
        }

        public Map<URN, Long> getUrnToTime() {
            return this.urnToTime;
        }
    }
}

