/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.SpamServices;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.net.SocketsManager;
import org.limewire.rudp.UDPMultiplexor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ConnectionServicesImpl
implements ConnectionServices {
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<HostCatcher> hostCatcher;
    private final Provider<UDPMultiplexor> udpMultiplexor;
    private final Provider<UploadManager> uploadManager;
    private final Provider<Acceptor> acceptor;
    private final Provider<SpamServices> spamServices;

    @Inject
    public ConnectionServicesImpl(Provider<ConnectionManager> provider, Provider<HostCatcher> provider2, Provider<UDPMultiplexor> provider3, Provider<UploadManager> provider4, Provider<Acceptor> provider5, Provider<SpamServices> provider6) {
        this.connectionManager = provider;
        this.hostCatcher = provider2;
        this.udpMultiplexor = provider3;
        this.uploadManager = provider4;
        this.acceptor = provider5;
        this.spamServices = provider6;
    }

    @Override
    public boolean isShieldedLeaf() {
        return ((ConnectionManager)this.connectionManager.get()).isShieldedLeaf();
    }

    @Override
    public boolean isActiveSuperNode() {
        return ((ConnectionManager)this.connectionManager.get()).isActiveSupernode();
    }

    @Override
    public boolean isSupernode() {
        return ((ConnectionManager)this.connectionManager.get()).isSupernode();
    }

    @Override
    public boolean isConnecting() {
        return ((ConnectionManager)this.connectionManager.get()).isConnecting();
    }

    @Override
    public boolean isConnected() {
        return ((ConnectionManager)this.connectionManager.get()).isConnected();
    }

    @Override
    public boolean isFullyConnected() {
        return ((ConnectionManager)this.connectionManager.get()).isFullyConnected();
    }

    @Override
    public Collection<IpPort> getPreferencedHosts(boolean bl, String string, int n) {
        IpPortSet ipPortSet = new IpPortSet();
        if (bl) {
            ipPortSet.addAll(((HostCatcher)this.hostCatcher.get()).getUltrapeersWithFreeUltrapeerSlots(string, n));
        } else {
            ipPortSet.addAll(((HostCatcher)this.hostCatcher.get()).getUltrapeersWithFreeLeafSlots(string, n));
        }
        if (ipPortSet.size() < n) {
            for (RoutedConnection routedConnection : ((ConnectionManager)this.connectionManager.get()).getInitializedConnectionsMatchLocale(string)) {
                if (ipPortSet.size() >= n) break;
                ipPortSet.add(routedConnection);
            }
            if (ipPortSet.size() < n) {
                for (RoutedConnection routedConnection : ((ConnectionManager)this.connectionManager.get()).getInitializedConnections()) {
                    if (ipPortSet.size() >= n) break;
                    ipPortSet.add(routedConnection);
                }
            }
        }
        return ipPortSet;
    }

    @Override
    public int countConnectionsWithNMessages(int n) {
        return ((ConnectionManager)this.connectionManager.get()).countConnectionsWithNMessages(n);
    }

    @Override
    public int getActiveConnectionMessages() {
        return ((ConnectionManager)this.connectionManager.get()).getActiveConnectionMessages();
    }

    @Override
    public void removeConnection(RoutedConnection routedConnection) {
        ((ConnectionManager)this.connectionManager.get()).remove(routedConnection);
    }

    @Override
    public void disconnect() {
        ((ConnectionManager)this.connectionManager.get()).disconnect(false);
    }

    @Override
    public void connect() {
        ((SpamServices)this.spamServices.get()).adjustSpamFilters();
        ((ConnectionManager)this.connectionManager.get()).connect();
    }

    @Override
    public boolean isConnectedTo(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress();
        return ((ConnectionManager)this.connectionManager.get()).isConnectedTo(string) || ((UDPMultiplexor)this.udpMultiplexor.get()).isConnectedTo(inetAddress) || ((UploadManager)this.uploadManager.get()).isConnectedTo(inetAddress);
    }

    @Override
    public void connectToHostAsynchronously(String string, int n, SocketsManager.ConnectType connectType) {
        InetAddress inetAddress;
        byte[] byArray = null;
        try {
            inetAddress = InetAddress.getByName(string);
            byArray = inetAddress.getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        if (byArray[0] == 127 && n == ((Acceptor)this.acceptor.get()).getPort(true) && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        byte[] byArray2 = ((Acceptor)this.acceptor.get()).getAddress(true);
        if (Arrays.equals(byArray, byArray2) && n == ((Acceptor)this.acceptor.get()).getPort(true)) {
            return;
        }
        if (((SpamServices)this.spamServices.get()).isAllowed(inetAddress)) {
            ((ConnectionManager)this.connectionManager.get()).createConnectionAsynchronously(string, n, connectType);
        }
    }

    @Override
    public int getNumInitializedConnections() {
        return ((ConnectionManager)this.connectionManager.get()).getNumInitializedConnections();
    }
}

