/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BrowseHostHandlerManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.limewire.http.httpclient.SocketWrappingHttpClient;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;
import org.limewire.service.ErrorService;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseHostHandler {
    private static final Log LOG = LogFactory.getLog(BrowseHostHandler.class);
    private static final int NOT_STARTED = -1;
    private static final int STARTED = 0;
    private static final int DIRECTLY_CONNECTING = 1;
    private static final int PUSHING = 2;
    private static final int EXCHANGING = 3;
    private static final int FINISHED = 4;
    static final int DIRECT_CONNECT_TIME = 10000;
    private static final long EXPIRE_TIME = 15000L;
    private static final int SPECIAL_INDEX = 0;
    private GUID _guid = null;
    private GUID _serventID = null;
    private volatile long _replyLength = 0L;
    private volatile long _currentLength = 0L;
    private volatile int _state = -1;
    private volatile long _stateStarted = 0L;
    private final BrowseHostHandlerManager.BrowseHostCallback browseHostCallback;
    private final ActivityCallback activityCallback;
    private final SocketsManager socketsManager;
    private final Provider<PushDownloadManager> pushDownloadManager;
    private final Provider<ReplyHandler> forMeReplyHandler;
    private final MessageFactory messageFactory;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final Provider<SocketWrappingHttpClient> clientProvider;
    private final NetworkInstanceUtils networkInstanceUtils;

    BrowseHostHandler(GUID gUID, GUID gUID2, BrowseHostHandlerManager.BrowseHostCallback browseHostCallback, ActivityCallback activityCallback, SocketsManager socketsManager, Provider<PushDownloadManager> provider, @Named(value="forMeReplyHandler") Provider<ReplyHandler> provider2, MessageFactory messageFactory, RemoteFileDescFactory remoteFileDescFactory, Provider<SocketWrappingHttpClient> provider3, NetworkInstanceUtils networkInstanceUtils) {
        this._guid = gUID;
        this._serventID = gUID2;
        this.browseHostCallback = browseHostCallback;
        this.activityCallback = activityCallback;
        this.socketsManager = socketsManager;
        this.pushDownloadManager = provider;
        this.forMeReplyHandler = provider2;
        this.messageFactory = messageFactory;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.clientProvider = provider3;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    public void browseHost(Connectable connectable, Set<? extends IpPort> set, boolean bl) {
        if (connectable == null) {
            assert (!bl) : "Can't do fwts without host";
            try {
                this.setState(0);
                this.browseFirewalledHost(BrowseHostHandler.createInvalidHost(), set, bl);
            }
            catch (UnknownHostException unknownHostException) {
                this.failed();
                ErrorService.error(unknownHostException, "Can't resolve host, should not happen");
            }
            return;
        }
        if (connectable.getInetSocketAddress().isUnresolved()) {
            try {
                connectable = new ConnectableImpl(connectable.getAddress(), connectable.getPort(), connectable.isTLSCapable());
            }
            catch (UnknownHostException unknownHostException) {
                this.failed();
                return;
            }
        }
        if (!NetworkUtils.isValidIpPort(connectable)) {
            this.failed();
            return;
        }
        LOG.trace((Object)"Starting browse protocol");
        this.setState(0);
        if (this.canConnectDirectly(connectable) || this.isLocalBrowse(connectable)) {
            try {
                SocketsManager.ConnectType connectType;
                this.setState(1);
                SocketsManager.ConnectType connectType2 = connectType = connectable.isTLSCapable() ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Attempting direct connection with type: " + (Object)((Object)connectType)));
                }
                Socket socket = this.socketsManager.connect(new InetSocketAddress(connectable.getAddress(), connectable.getPort()), 10000, connectType);
                LOG.trace((Object)"Direct connect successful");
                this.browseHost(socket);
                return;
            }
            catch (IOException iOException) {
                LOG.debug((Object)"Error during direct transfer", (Throwable)iOException);
            }
            catch (HttpException httpException) {
                LOG.debug((Object)"Error during direct transfer", (Throwable)httpException);
            }
            catch (URISyntaxException uRISyntaxException) {
                LOG.debug((Object)"Error during direct transfer", (Throwable)uRISyntaxException);
            }
            catch (InterruptedException interruptedException) {
                LOG.debug((Object)"Error during direct transfer", (Throwable)interruptedException);
            }
        }
        this.browseFirewalledHost(connectable, set, bl);
    }

    private void browseFirewalledHost(Connectable connectable, Set<? extends IpPort> set, boolean bl) {
        LOG.debug((Object)"Attempting push connection");
        if (this._serventID == null) {
            LOG.debug((Object)"No serventID, failing");
            this.failed();
        } else {
            RemoteFileDesc remoteFileDesc = this.remoteFileDescFactory.createRemoteFileDesc(connectable.getAddress(), connectable.getPort(), 0L, "fake", 0L, this._serventID.bytes(), 0, false, 0, false, null, null, false, true, "", set, -1L, bl ? 1 : 0, connectable.isTLSCapable());
            this.browseHostCallback.putInfo(this._serventID, new PushRequestDetails(this));
            LOG.trace((Object)"Sending push request");
            this.setState(2);
            ((PushDownloadManager)this.pushDownloadManager.get()).sendPush(remoteFileDesc);
        }
    }

    static Connectable createInvalidHost() throws UnknownHostException {
        return new ConnectableImpl("0.0.0.0", 1, false);
    }

    public double getPercentComplete(long l) {
        switch (this._state) {
            case -1: {
                return 0.0;
            }
            case 0: {
                return 0.0;
            }
            case 1: {
                long l2 = l - this._stateStarted;
                return (double)l2 / 10000.0;
            }
            case 2: {
                long l3 = l - this._stateStarted;
                return (double)l3 / 15000.0;
            }
            case 3: {
                if (this._replyLength > 0L) {
                    return (double)this._currentLength / (double)this._replyLength;
                }
                return 0.5;
            }
            case 4: {
                return 1.0;
            }
        }
        throw new IllegalStateException("invalid state");
    }

    private void setState(int n) {
        this._state = n;
        this._stateStarted = System.currentTimeMillis();
    }

    void failed() {
        this.setState(4);
        this.activityCallback.browseHostFailed(this._guid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void browseHost(Socket socket) throws IOException, URISyntaxException, HttpException, InterruptedException {
        try {
            this.setState(3);
            HttpResponse httpResponse = this.makeHTTPRequest(socket);
            this.validateResponse(httpResponse);
            this.readQueryRepliesFromStream(httpResponse);
        }
        finally {
            IOUtils.close(socket);
            this.setState(4);
        }
    }

    private HttpResponse makeHTTPRequest(Socket socket) throws IOException, URISyntaxException, HttpException, InterruptedException {
        SocketWrappingHttpClient socketWrappingHttpClient = (SocketWrappingHttpClient)this.clientProvider.get();
        socketWrappingHttpClient.setSocket(socket);
        HttpGet httpGet = new HttpGet("http://" + NetworkUtils.ip2string(socket.getInetAddress().getAddress()) + ":" + socket.getPort() + "/");
        HttpProtocolParams.setVersion((HttpParams)socketWrappingHttpClient.getParams(), (ProtocolVersion)HttpVersion.HTTP_1_1);
        httpGet.addHeader("Host", NetworkUtils.ip2string(socket.getInetAddress().getAddress()) + ":" + socket.getPort());
        httpGet.addHeader("User-Agent", LimeWireUtils.getVendor());
        httpGet.addHeader("Accept", "application/x-gnutella-packets");
        httpGet.addHeader("Connection", "close");
        return socketWrappingHttpClient.execute((HttpUriRequest)httpGet);
    }

    private void validateResponse(HttpResponse httpResponse) throws IOException {
        if (httpResponse.getStatusLine().getStatusCode() < 200 || httpResponse.getStatusLine().getStatusCode() >= 300) {
            throw new IOException("HTTP status code = " + httpResponse.getStatusLine().getStatusCode());
        }
        Header header = httpResponse.getFirstHeader("Content-Type");
        if (header != null && StringUtils.indexOfIgnoreCase(header.getValue(), "application/x-gnutella-packets", Locale.ENGLISH) < 0) {
            throw new IOException("Unsupported Content-Type: " + header.getValue());
        }
        Header header2 = httpResponse.getFirstHeader("Content-Encoding");
        if (header2 != null) {
            throw new IOException("Unsupported Content-Encoding: " + header2.getValue());
        }
        Header header3 = httpResponse.getFirstHeader("Content-Length");
        if (header3 != null) {
            try {
                this._replyLength = Long.parseLong(header3.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void readQueryRepliesFromStream(HttpResponse httpResponse) {
        if (httpResponse.getEntity() != null) {
            InputStream inputStream;
            try {
                inputStream = httpResponse.getEntity().getContent();
            }
            catch (IOException iOException) {
                LOG.debug((Object)"Unable to read a single message", (Throwable)iOException);
                return;
            }
            Message message = null;
            while (true) {
                try {
                    message = null;
                    LOG.debug((Object)"reading message");
                    message = this.messageFactory.read(inputStream, Message.Network.TCP);
                }
                catch (BadPacketException badPacketException) {
                    LOG.debug((Object)"BPE while reading", (Throwable)badPacketException);
                }
                catch (IOException iOException) {
                    LOG.debug((Object)"IOE while reading", (Throwable)iOException);
                }
                if (message == null) {
                    LOG.debug((Object)"Unable to read create message");
                    return;
                }
                if (!(message instanceof QueryReply)) continue;
                this._currentLength += (long)message.getTotalLength();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("BHH.browseExchange(): read QR:" + message));
                }
                QueryReply queryReply = (QueryReply)message;
                queryReply.setGUID(this._guid);
                queryReply.setBrowseHostReply(true);
                ((ReplyHandler)this.forMeReplyHandler.get()).handleQueryReply(queryReply, null);
            }
        }
    }

    private boolean canConnectDirectly(IpPort ipPort) {
        return !ConnectionSettings.LOCAL_IS_PRIVATE.getValue() || !this.networkInstanceUtils.isPrivateAddress(ipPort.getAddress()) || this.networkInstanceUtils.isMe(ipPort.getAddress(), ipPort.getPort());
    }

    private boolean isLocalBrowse(IpPort ipPort) {
        return this._serventID == null && this.networkInstanceUtils.isPrivateAddress(ipPort.getAddress());
    }

    public static class PushRequestDetails {
        private BrowseHostHandler bhh;
        private long timeStamp = System.currentTimeMillis();

        public PushRequestDetails(BrowseHostHandler browseHostHandler) {
            this.bhh = browseHostHandler;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timeStamp > 15000L;
        }

        public BrowseHostHandler getBrowseHostHandler() {
            return this.bhh;
        }
    }
}

