/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import java.util.Arrays;
import java.util.Set;
import org.limewire.collection.BitNumbers;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPushEndpoint
implements PushEndpoint {
    @Override
    public byte[] toBytes(boolean bl) {
        Set<? extends IpPort> set = this.getProxies();
        int n = AbstractPushEndpoint.getSizeBytes(set, bl);
        IpPort ipPort = this.getValidExternalAddress();
        int n2 = this.getFWTVersion();
        if (ipPort != null && n2 > 0) {
            n += 6;
        }
        byte[] byArray = new byte[n];
        this.toBytes(byArray, 0, set, ipPort, n2, bl);
        return byArray;
    }

    @Override
    public void toBytes(byte[] byArray, int n, boolean bl) {
        this.toBytes(byArray, n, this.getProxies(), this.getValidExternalAddress(), this.getFWTVersion(), bl);
    }

    protected void toBytes(byte[] byArray, int n, Set<? extends IpPort> set, IpPort ipPort, int n2, boolean bl) {
        int n3;
        int n4 = AbstractPushEndpoint.getSizeBytes(set, bl);
        if (ipPort != null) {
            if (n2 > 0) {
                n4 += 6;
            }
        } else {
            n2 = 0;
        }
        if (byArray.length - n < n4) {
            throw new IllegalArgumentException("target array too small");
        }
        int n5 = n;
        byArray[n] = (byte)(Math.min(4, set.size()) | this.getFeatures() | n2 << 3);
        System.arraycopy(this.getClientGUID(), 0, byArray, ++n, 16);
        n += 16;
        if (ipPort != null && n2 > 0) {
            byte[] byArray2 = ipPort.getInetAddress().getAddress();
            n3 = ipPort.getPort();
            System.arraycopy(byArray2, 0, byArray, n, 4);
            ByteUtils.short2leb((short)n3, byArray, n += 4);
            n += 2;
        }
        int n6 = n;
        n3 = 0;
        if (bl) {
            for (IpPort object2 : set) {
                if (n3 >= 4) break;
                if (object2 instanceof Connectable && ((Connectable)object2).isTLSCapable()) {
                    ++n;
                    break;
                }
                ++n3;
            }
        }
        n3 = 0;
        Object object3 = set.iterator();
        while (object3.hasNext()) {
            IpPort ipPort2 = object3.next();
            if (n3 >= 4) break;
            byte[] byArray2 = ipPort2.getInetAddress().getAddress();
            short s = (short)ipPort2.getPort();
            System.arraycopy(byArray2, 0, byArray, n, 4);
            ByteUtils.short2leb(s, byArray, n += 4);
            n += 2;
            ++n3;
        }
        Object object = object3 = bl ? HTTPHeaderUtils.getTLSIndices(set, Math.min(set.size(), 4)) : BitNumbers.EMPTY_BN;
        if (!((BitNumbers)object3).isEmpty()) {
            byte[] byArray3 = ((BitNumbers)object3).toByteArray();
            assert (byArray3.length == 1);
            byArray[n6] = byArray3[0];
            int n7 = n5;
            byArray[n7] = (byte)(byArray[n7] | 0xFFFFFF80);
        } else {
            int n8 = n5;
            byArray[n8] = (byte)(byArray[n8] & 0x7F);
        }
    }

    @Override
    public final boolean equals(Object object) {
        if (object instanceof PushEndpoint) {
            return Arrays.equals(this.getClientGUID(), ((PushEndpoint)object).getClientGUID());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return new GUID(this.getClientGUID()).hashCode();
    }

    @Override
    public String httpStringValue() {
        Object object;
        GUID gUID = new GUID(this.getClientGUID());
        StringBuilder stringBuilder = new StringBuilder(gUID.toHexString()).append(";");
        int n = this.getFWTVersion();
        if (n != 0) {
            stringBuilder.append("fwt").append("/").append(n).append(";");
            object = this.getValidExternalAddress();
            if (object != null) {
                String string = object.getAddress();
                int n2 = object.getPort();
                if (!string.equals("1.1.1.1") && NetworkUtils.isValidPort(n2)) {
                    stringBuilder.append(n2).append(":").append(string).append(";");
                }
            }
        }
        if (!(object = this.getProxies()).isEmpty()) {
            stringBuilder.append(HTTPHeaderUtils.encodePushProxies(object, ";", 4));
        } else {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        String string = "PE [FEATURES:" + this.getFeatures() + ",\nFWT Version:" + this.getFWTVersion() + ",\nGUID:" + new GUID(this.getClientGUID()) + ", address: " + this.getAddress() + ":" + this.getPort() + ",\nproxies:{ ";
        for (IpPort ipPort : this.getProxies()) {
            string = string + ipPort.getInetAddress() + ":" + ipPort.getPort() + "\n";
        }
        string = string + "}]";
        return string;
    }

    public static int getSizeBytes(Set<? extends IpPort> set, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            int n = 0;
            for (IpPort ipPort : set) {
                if (n >= 4) break;
                if (ipPort instanceof ConnectableImpl && ((Connectable)ipPort).isTLSCapable()) {
                    bl2 = true;
                    break;
                }
                ++n;
            }
        }
        return 17 + (bl2 ? 1 : 0) + Math.min(set.size(), 4) * 6;
    }
}

