/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.Enumeration;
import java.util.Properties;
import net.sourceforge.pmd.swingui.Constants;

public class RuleProperties
implements Constants {
    private Properties m_properties = new Properties();
    private static final String SEPARATOR = "&PS;";

    public boolean containsKey(String name) {
        return this.m_properties.containsKey(name);
    }

    public Enumeration keys() {
        return this.m_properties.keys();
    }

    public int size() {
        return this.m_properties.size();
    }

    public String getValue(String name) {
        String property;
        String string = name = name == null ? "" : name.trim();
        if (name.length() > 0 && (property = this.m_properties.getProperty(name)) != null) {
            int index = property.indexOf(SEPARATOR);
            return index < 0 ? property : property.substring(0, index);
        }
        return "";
    }

    public String getValueType(String name) {
        int index;
        String property;
        String string = name = name == null ? "" : name.trim();
        if (name.length() > 0 && (property = this.m_properties.getProperty(name)) != null && (index = property.indexOf(SEPARATOR) + SEPARATOR.length()) > 0) {
            return property.substring(index);
        }
        return "";
    }

    public boolean getBooleanValue(String name) {
        return Boolean.getBoolean(this.getValue(name));
    }

    public double getDoubleValue(String name) {
        try {
            return Double.parseDouble(this.getValue(name));
        }
        catch (NumberFormatException exception) {
            return 0.0;
        }
    }

    public int getIntegerValue(String name) {
        try {
            return Integer.parseInt(this.getValue(name));
        }
        catch (NumberFormatException exception) {
            return 0;
        }
    }

    public String getProperty(String name) {
        return this.getValue(name);
    }

    public Object setProperty(String name, String value) {
        this.setValue(name, value);
        return null;
    }

    public void setValue(String name, String value) {
        String string = name = name == null ? "" : name.trim();
        if (name.length() > 0) {
            if (value == null) {
                value = "";
            }
            String valueType = this.getValueType(name);
            String property = value + SEPARATOR + valueType;
            this.m_properties.setProperty(name, property);
        }
    }

    public void setValueType(String name, String valueType) {
        String string = name = name == null ? "" : name.trim();
        if (name.length() > 0) {
            if (valueType == null) {
                valueType = "";
            }
            String value = this.getValue(name);
            String property = value + SEPARATOR + valueType;
            this.m_properties.setProperty(name, property);
        }
    }
}

