/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import java.io.IOException;
import java.util.Vector;
import org.cybergarage.net.HostInterface;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.ssdp.SSDP;
import org.cybergarage.upnp.ssdp.SSDPSearchRequest;
import org.cybergarage.upnp.ssdp.SSDPSearchResponseSocket;

public class SSDPSearchResponseSocketList
extends Vector {
    public void setControlPoint(ControlPoint ctrlPoint) {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            sock.setControlPoint(ctrlPoint);
        }
    }

    public SSDPSearchResponseSocket getSSDPSearchResponseSocket(int n) {
        return (SSDPSearchResponseSocket)this.get(n);
    }

    public boolean open(int port) {
        try {
            int nHostAddrs = HostInterface.getNHostAddresses();
            for (int n = 0; n < nHostAddrs; ++n) {
                String bindAddr = HostInterface.getHostAddress(n);
                SSDPSearchResponseSocket socket = null;
                try {
                    socket = new SSDPSearchResponseSocket(bindAddr, port);
                }
                catch (IOException iox) {
                    continue;
                }
                this.add(socket);
            }
        }
        catch (Exception e) {
            this.stop();
            this.close();
            this.clear();
            return false;
        }
        return !this.isEmpty();
    }

    public boolean open() {
        return this.open(1900);
    }

    public void close() {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            sock.close();
        }
        this.clear();
    }

    public void start() {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            sock.start();
        }
    }

    public void stop() {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            sock.stop();
        }
    }

    public boolean post(SSDPSearchRequest req) {
        boolean ret = true;
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            String bindAddr = sock.getLocalAddress();
            if (bindAddr == null) continue;
            req.setLocalAddress(bindAddr);
            String ssdpAddr = "239.255.255.250";
            if (HostInterface.isIPv6Address(bindAddr)) {
                ssdpAddr = SSDP.getIPv6Address();
            }
            if (sock.post(ssdpAddr, 1900, req)) continue;
            ret = false;
        }
        return ret;
    }
}

