/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class Utils {
    public static void copy(byte[] src, byte[] dst, int dstOffset) {
        System.arraycopy(src, 0, dst, dstOffset, src.length);
    }

    public static byte[] getDefaultBytes(String s, String charSet) {
        try {
            return s.getBytes(charSet);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static String getExtension(File f) {
        String name = f.getName().toLowerCase();
        int i = name.lastIndexOf(".");
        if (i == -1) {
            return "";
        }
        return name.substring(i + 1);
    }

    public static long getLongNumberLittleEndian(ByteBuffer b, int start, int end) {
        long number = 0L;
        int i = 0;
        while (i < end - start + 1) {
            number += (long)((b.get(start + i) & 0xFF) << i * 8);
            ++i;
        }
        return number;
    }

    public static long getLongNumberBigEndian(ByteBuffer b, int start, int end) {
        int number = 0;
        int i = 0;
        while (i < end - start + 1) {
            number += (b.get(end - i) & 0xFF) << i * 8;
            ++i;
        }
        return number;
    }

    public static int getNumberLittleEndian(byte[] b) {
        return (int)Utils.getLongNumberLittleEndian(ByteBuffer.wrap(b), 0, b.length - 1);
    }

    public static int getNumberLittleEndian(byte[] b, int start, int end) {
        return (int)Utils.getLongNumberLittleEndian(ByteBuffer.wrap(b), start, end);
    }

    public static int getNumberBigEndian(byte[] b, int start, int end) {
        return (int)Utils.getLongNumberBigEndian(ByteBuffer.wrap(b), start, end);
    }

    public static int getNumberBigEndian(ByteBuffer b, int start, int end) {
        return (int)Utils.getLongNumberBigEndian(b, start, end);
    }

    public static short getShortNumberBigEndian(ByteBuffer b, int start, int end) {
        return (short)Utils.getNumberBigEndian(b, start, end);
    }

    public static byte[] getSizeBigEndian(int size) {
        byte[] b = new byte[]{(byte)(size >> 24 & 0xFF), (byte)(size >> 16 & 0xFF), (byte)(size >> 8 & 0xFF), (byte)(size & 0xFF)};
        return b;
    }

    public static byte[] getShortSizeBigEndian(short size) {
        byte[] b = new byte[]{(byte)(size >> 8 & 0xFF), (byte)(size & 0xFF)};
        return b;
    }

    public static byte[] getSizeLittleEndian(int size) {
        byte[] b = new byte[]{(byte)(size & 0xFF), (byte)((long)(size >>> 8) & 0xFFL), (byte)((long)(size >>> 16) & 0xFFL), (byte)((long)(size >>> 24) & 0xFFL)};
        return b;
    }

    public static String getString(byte[] b, int offset, int length, String encoding) {
        try {
            return new String(b, offset, length, encoding);
        }
        catch (UnsupportedEncodingException ue) {
            throw new RuntimeException(ue);
        }
    }

    public static String getString(ByteBuffer buffer, int offset, int length, String encoding) {
        byte[] b = new byte[length];
        buffer.position(buffer.position() + offset);
        buffer.get(b);
        try {
            return new String(b, 0, length, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public static byte[] getUTF8Bytes(String s) throws UnsupportedEncodingException {
        return s.getBytes("UTF-8");
    }
}

