/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.ant.gettext;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Commandline;
import org.xnap.commons.ant.gettext.AbstractGettextGenerateTask;

public class GettextDistTask
extends AbstractGettextGenerateTask {
    protected int percentage = 0;
    protected String moreOrLess = "greaterOrEqual";

    public void setPercentage(int n) {
        this.percentage = n;
    }

    public void setMoreOrLess(String string) {
        this.moreOrLess = string;
    }

    public void execute() {
        this.checkPreconditions();
        AbstractGettextGenerateTask.CommandlineFactory commandlineFactory = this.getCommandlineFactory();
        String[] stringArray = this.getPoFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            this.log("Processing " + stringArray[i]);
            if (this.percentage > 0 && !this.fileMatchesPercentage(new File(this.poDirectory, stringArray[i]))) {
                this.log("Skipping " + stringArray[i]);
                continue;
            }
            Commandline commandline = commandlineFactory.createCommandline(new File(this.poDirectory, stringArray[i]));
            this.log("Executing: " + commandline.toString(), 4);
            this.runCommandLineAndWait(commandline);
        }
    }

    boolean fileMatchesPercentage(File file) {
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.msgfmtCmd);
        commandline.createArgument().setValue("--statistics");
        commandline.createArgument().setFile(file);
        try {
            int n;
            int n2;
            Process process = Runtime.getRuntime().exec(commandline.getCommandline());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[1024];
            while ((n2 = bufferedReader.read(cArray, 0, cArray.length)) != -1) {
                stringBuilder.append(cArray, 0, n2);
            }
            String string = stringBuilder.toString();
            if (string.startsWith("0")) {
                if (this.getProject() != null) {
                    this.log(MessageFormat.format("{0} has {1}% translated", file.getName(), 0), 2);
                }
                return this.evaluatePercentage(0);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n3 = 0;
            n3 = n = Integer.parseInt(stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) break;
                stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) break;
                n3 += Integer.parseInt(stringTokenizer.nextToken());
            }
            int n4 = (int)(100.0 * (double)n / (double)n3);
            if (this.getProject() != null) {
                this.log(MessageFormat.format("{0} has {1}% translated", file.getName(), n4), 2);
            }
            return this.evaluatePercentage(n4);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException(numberFormatException.getMessage());
        }
    }

    private boolean evaluatePercentage(int n) {
        if (this.moreOrLess.equals("greaterOrEqual")) {
            return n >= this.percentage;
        }
        return n < this.percentage;
    }
}

