
/**
 * @class ソース表示部品
 * @constructor
 * @extends Bredima.Panel.Dialog
 */
Bredima.Frame.Source = function(bredima) {
    this.__super__();
    this.frame.addClassName('source_frame');

    this.getter = [
	function(){return bredima.toMML()},
	function(){return bredima.toLatex()},
	function(){return bredima.toJSON()}
    ];
    var label = ['MathML', 'LaTeX'];
    if(bredima.getConfig('showJson') == true) label.push('JSON');
    this.tab = new Bredima.Panel.Tab(label);
    this.tab.observer.attach(this);
    this.tab.hilite(0);
    this.frame.add(this.tab);

    // 実際に表示する場所
    this.field = document.createElement('textarea');
    this.field.className = 'source_field';
    this.frame.addDom(this.field);
}

Bredima.util.inherit(Bredima.Frame.Source, Bredima.Panel.Dialog);

Bredima.Frame.Source.prototype.show = function() {
    Bredima.util.applySuper('show', this);
    this.field.value = this.getter[this.tab.getSelectedNum()]();
}

/**
 * ソース種類切り替えタブのクリックを受信
 * @private
 */
Bredima.Frame.Source.prototype.onTabClick = function(num) {
    this.field.value = this.getter[num]();
}

Bredima.style.add(
    ['.source_field', 'width: 100%; height: 10em;']
);
