
/**
 * @class プレビュー部品
 * @constructor
 * @extends Bredima.Panel
 * @param {Object} bredima bredima
 */
Bredima.Frame.Preview = function(bredima) {
    this.__super__();
    this.bredima = bredima;
    this.isMML = bredima.getConfig('isMML');
    this.timer = ''; // 自動プレビューのためのタイマー
    var self = this;
    this.setClassName('preview');

    //ボタン表示の場合は表示領域を明け渡す
    if(bredima.getConfig('use_button'))
	this.obj.style.width = '85%';

    // タブ部品で表示状態の切り替え
    this.add(new Bredima.Panel.Tab(['Preview']), 'tab');
    this.tab.observer.attach(this);

    // 非表示時に隠すものはframe内に
    var frame = new Bredima.Panel();
    frame.setClassName('preview_frame');
    frame.hide();

    var toolbar = new Bredima.Panel();
    toolbar.setClassName('preview_toolbar');

    // Updateボタン
    toolbar.add(new Bredima.Parts.Button(new Bredima.Parts.Image('btn_reload.png'),
					    function() {self.preview(); }), 'button');

    // 自動更新チェック
    var t = document.createElement('input');
    t.type = 'checkbox'; // DOMツリーに組み込む前でないとIEでエラーが出る
    toolbar.addDom(t, 'check');
    toolbar.addDom(document.createTextNode('Automatic'));

    frame.add(toolbar, 'toolbar');

    // 表示領域
    frame.add(new Bredima.Panel(), 'display');
    frame.display.setClassName('preview_display');
    if(!this.isMML) {
	this.image = document.createElement('img');
	frame.display.addDom(this.image, 'img');
    }

    this.add(frame, 'frame');
}

Bredima.util.inherit(Bredima.Frame.Preview, Bredima.Panel);

/**
 * 実際にプレビューを領域内に表示
 */
Bredima.Frame.Preview.prototype.preview = function() {
    if(this.isMML)
	this.frame.display.innerHTML = this.bredima.toMML('expand');
    else
	this.image.src = Bredima.util.getTexURI(this.bredima.toLatex(), 'Large');
}

/**
 * タブを押した際の処理
 * @private
 */
Bredima.Frame.Preview.prototype.onTabClick = function() {
    var self = this;
    if(this.frame.getVisibility()) {
	clearTimeout(this.timer);
	Bredima.util.smoothAnimation( {
				    start: 70, end: 1, step: 6,
				    func: function(num) { self.frame.getDom().style.height = Math.floor(num) + 'px';},
				    finalize: function() {
					self.frame.hide();
					self.tab.hilite(-1);
				    }
				});
    }
    else {
	this.frame.getDom().style.height = '1px';
	this.frame.show();
	this.preview();
	Bredima.util.smoothAnimation({
				   start: 1, end: 70, step: 6,
				   func: function(num) {self.frame.getDom().style.height = Math.floor(num) + 'px';}
			       });
    }
}

/**
 * 数式の変更を受信した際の処理
 * 受信後0.5秒後にプレビュー更新
 * @private
 */
Bredima.Frame.Preview.prototype.onExpressionChange = function() {
    if(this.frame.getVisibility() && this.frame.toolbar.check.checked) {
	var self = this;
	clearTimeout(this.timer);
	this.timer = setTimeout(function() {self.preview();}, 500);
    }
}

Bredima.style.add(
    ['.preview', 'position: absolute; bottom: 2px; width: 99%; z-index: 1;'],
    ['.preview .preview_frame', 'background-color: #eee; padding: 5px; position: relative; overflow: hidden;'],
    ['.preview .preview_display', 'background-color: white; padding: 10px;'],
    ['.preview .preview_toolbar', 'position: absolute; right: 5px; top: 0px; padding: 4px 10px; background-color: #eee;']
);
