
/**
 * @class フレーム管理
 * @constructor
 * @extends Bredima.Panel
 */
Bredima.Frame = function(bredima, dom) {
    this.bredima = bredima;
    this.obj = dom;
    this.obj.className = 'BrEdiMa_Frame';
    this.isVisible = true;

    // loading中の目隠し
/*    this.addDom('div', 'curtain');
    this.curtain.className = 'curtain';
    var note = document.createElement('p');
    note.appendChild(document.createTextNode('loading'));
    this.curtain.appendChild(note);
*/
    this.eventObserver = new Bredima.Observer();
    var self = this;
    this.addListener('click', function() {self.eventObserver.notify('FrameClick');});

    // About表示関係
    this.add(new Bredima.Frame.About(bredima), 'about');
    var logo = new Bredima.Parts.Image('logo.png');
    logo.addClassName('bredima_logo');
    logo.addListener('click', function() { bredima.frame.about.show(); });
    this.add(logo);

    this.add(new Bredima.Frame.Source(bredima), 'source');
    this.add(new Bredima.Frame.Preview(bredima), 'preview');

    if(bredima.getConfig('use_button'))
	this.add(new Bredima.Frame.CtrlButtons(bredima), 'buttons');
}

Bredima.util.inherit(Bredima.Frame, Bredima.Panel);

/**
 * 他のクラスの初期化が終わってから行う処理
 */
Bredima.Frame.prototype.finalize = function() {
    this.add(new Bredima.Frame.Toolbar(this.bredima), 'toolbar');
    this.add(this.bredima.exp.root);

    // 数式更新のタイミングでプレビューのアップデートをnotify
    this.bredima.exp.observer.attach(this.preview);
}

/**
 * ロード中の目隠しを取り去る
 */
Bredima.Frame.prototype.appear = function() {
    var self = this;
    Bredima.util.animation({
			       start: 1, end: 0, step: 4,
			       func: function(num) {
				   Bredima.util.setOpacity(self.curtain, num);
			       },
			       finalize: function(){self.curtain.style.display = 'none';}
			   });
}
    
Bredima.style.add(
    [' ', 'position: relative; border: 1px solid #dcc; background-color: white; color: black; font-size: 14px; line-height: 1; padding: 2px; height: 200px; text-align: left;'],
    ['.curtain', 'position: absolute; width: 100%; height: 100%; left: 0; top: 0; background-color: #f2eeee; z-index: 10; text-align: center; vertical-align: bottom;'],
    ['.curtain p', 'position: absolute; bottom: 30%; left: 60%;'],
    ['.bredima_logo', 'position: absolute; top: 3px; right: 3px;']
);


Bredima.Frame.CtrlButtons = function(bredima) {
    this.__super__();

    this.setClassName('ctrlbuttons')

    var btn = new Bredima.Parts.Button(new Bredima.Parts.String('挿入'), 
		       function() {
			   bredima.frame.hide();
			   bredima.onsubmit();
		       });
    this.add(btn);
}

Bredima.util.inherit(Bredima.Frame.CtrlButtons, Bredima.Panel);

Bredima.style.add(
    ['.ctrlbuttons', 'position: absolute; right: 2px; bottom: 2px; width: 15%; text-align: center;']
);

