
Bredima.Exp.Root = function(exp) {
    this.exp = exp;
    this.__super__();
    this.obj.className = 'exproot';

    this.row = new Bredima.Exp.Row({parent: this, level: 1});
    this.obj.appendChild(this.row.getDom());
}

Bredima.util.inherit(Bredima.Exp.Root, Bredima.Exp);

Bredima.Exp.register(Bredima.Exp.Root, 'container', 'exproot');

Bredima.Exp.Root.prototype.toRundown = function() {
    return this.row.toRundown();
}

Bredima.Exp.Root.prototype.toMML = function(expand) {
    var out = '<math xmlns="http://www.w3.org/1998/Math/MathML" display="block">' + "\n";
    out += this.row.toMML(expand);
    out += '</math>' + "\n";
    return out;
}

Bredima.Exp.Root.prototype.toLatex = function() {
    return this.row.toLatex('noFence');
}

Bredima.Exp.Root.prototype.repositionAll = function() {
    this.row.repositionAll();
}

Bredima.Exp.Root.prototype.repositionToRoot = function() {
}

Bredima.Exp.Root.prototype.orderOf = function() {
    return 0;
}

Bredima.Exp.Root.prototype.getRow = function() {
    return this.row;
}

Bredima.Exp.Root.prototype.setCursorTo = function(loc) {
    this.row.setCursorToRow(loc);
}

Bredima.style.add(
    ['.exproot', 'position: relative;']
);
