

/* ===============================
*/
/**
 * @class オーバーライン
 * @extends Bredima.Container
 * @constructor
 * @param {Object} param オブジェクト構築共通パラメタ
 */
Bredima.Container.Over = function(param) {
    this.__super__(param);
    this.add('line', new Bredima.Parts.Separator());
    this.parts.line.setPos(2, 2);
}

Bredima.util.inherit(Bredima.Container.Over, Bredima.Container);

Bredima.util.setProperty(Bredima.Container.Over, {
			     MML: 'mover',
			     tex: 'overline',
			     padding: {top: 4, right: 0, bottom: 0, left: 0}
			 });

Bredima.Exp.register(Bredima.Container.Over, 'container', 'over');

Bredima.Container.Over.prototype._toMMLContent = function(expand) {
    return this.content.toMML(expand) +
	Bredima.util.addTag('mo', (expand) ? Bredima.Parts.Symbol.all.OverBar.code : '&OverBar;');
}

Bredima.Container.Over.prototype._repositionContent = function() {
    Bredima.util.applySuper('_repositionContent', this, arguments);
    this.parts.line.setSize(this.width - 4, 1);
}

/* ===============================
*/
/**
 * @class ベクトル
 * @extends Bredima.Container
 * @constructor
 * @param {Object} param オブジェクト構築共通パラメタ
 */
Bredima.Container.Vector = function(param) {
    this.__super__(param);
    this.add('head', new Bredima.Parts.Image('arrowhead.png'));
    this.add('shaft', new Bredima.Parts.Image('arrowshaft.png'));
    this.parts.shaft.setPos(2, 2);
}

Bredima.util.inherit(Bredima.Container.Vector, Bredima.Container);

Bredima.util.setProperty(Bredima.Container.Vector, {
			     MML: 'mover',
			     tex: 'vec',
			     padding: {top: 10, right: 0, bottom: 0, left: 0}
			 });

Bredima.Exp.register(Bredima.Container.Vector, 'container', 'vector');

Bredima.Container.Vector.prototype._toMMLContent = function(expand) {
    return this.content.toMML(expand) +
	Bredima.util.addTag('mo', (expand) ? Bredima.Parts.Symbol.all.rarr.code : '&RightArrow;');
    //RightArrowはrarrのエイリアス
}

Bredima.Container.Vector.prototype._repositionContent = function() {
    Bredima.util.applySuper('_repositionContent', this, arguments);
    this.parts.shaft.setSize(this.width - 14, 9);
    this.parts.head.setPos(this.width - 12, 2);
}

/* ===============================
*/
/**
 * @class 順列・組合せ・重複組合せ
 * @extends Bredima.Container
 * @constructor
 * @param {Object} param オブジェクト構築共通パラメタ
 * @param {Number} kind 種類
 *     0: 順列(Permutation), 1: 組合せ(Combination), 2: 重複組合せ(Homogeneous)
 */

Bredima.Container.Permutation = function(param, kind) {
    this.__super__(param);
    this.kind = (this.config) ? this.config : kind;
    this.add('symbol', new Bredima.Parts.String(this.values[this.kind], 1));
    this.add('menu', new Bredima.Parts.Popup(this.exp.bredima, 'permutation', this));
}

Bredima.util.inherit(Bredima.Container.Permutation, Bredima.Container);

Bredima.util.setProperty(Bredima.Container.Permutation, {
			     MML: 'mmultiscripts',
			     rowCount: 2,
			     rowLevels: [2, 2]
			 });

Bredima.Exp.register(Bredima.Container.Permutation, 'container', 'permutation');

Bredima.Container.Permutation.prototype.values = ['P', 'C', 'H'];

/* ------------------
 Containerの実装
*/
Bredima.Container.Permutation.prototype._toRundownContentParam = function() {
    return this.kind;
}

/* ------------------
 Expの実装
*/
Bredima.Container.Permutation.prototype._toMMLContent = function(expand) {
    return Bredima.util.addTag('mi', this.values[this.kind]) +
	this.rows[1].toMML(expand) + '<none/>' + "\n" +
	'<mprescripts/>' + "\n" +
	this.rows[0].toMML(expand) + '<none/>' + "\n";
}

Bredima.Container.Permutation.prototype.toLatex = function() {
    return '{{}_' + this.rows[0].toLatex() +
	this.values[this.kind] +
	'_' + this.rows[1].toLatex() + '}';
}

Bredima.Container.Permutation.prototype._repositionContent = function(ps) {
    var symbol = this.parts.symbol.getPreferredSize();
    this.width = symbol.width + ps[0].width + ps[1].width + 8;
    this.top = symbol.top;
    this.bottom = Math.max(ps[0].height, ps[1].height, symbol.bottom);

    this._resize();
    this.parts.symbol.setPos(ps[0].width, 0);
    this.parts.menu.setPos(this.width - 8, this.height - 8);
    this.rows[0].setPos(0, symbol.top);
    this.rows[1].setPos(ps[0].width + symbol.width, symbol.top);
}

/* ------------------
 PopupListenerの実装
*/
Bredima.Container.Permutation.prototype.menuClickPerformed = function(arg) {
    if(this.kind != arg) {
	this.exp.startRowRec(this.row);
	this.kind = arg;
	this.parts.symbol.setString(this.values[this.kind]);
	this.exp.endRowRec();
    }
}

/* ===============================
*/
/**
 * @class 総和
 * @extends Bredima.Container
 * @constructor
 * @param {Object} param オブジェクト構築共通パラメタ
 */
Bredima.Container.Sum = function(param) {
    this.__super__(param);
    this.add('symbol', new Bredima.Parts.Symbol(this.exp.bredima, 'sum', this.row.level));
}

Bredima.util.inherit(Bredima.Container.Sum, Bredima.Container);

Bredima.util.setProperty(Bredima.Container.Sum, {
			     MML: 'munderover',
			     rowCount: 2,
			     rowLevels: [2, 2],
			     verticalOrder: [1, 0]
			 });

Bredima.Exp.register(Bredima.Container.Sum, 'container', 'sum');

Bredima.Container.Sum.prototype._toMMLContent = function(expand) {
    return Bredima.util.addTag('mo', this.parts.symbol.toMML(expand)) +
	Bredima.util.applySuper('_toMMLContent', this);
}

Bredima.Container.Sum.prototype.toLatex = function() {
    return this.parts.symbol.toLatex() +
	'_' + this.rows[0].toLatex() +
	'^' + this.rows[1].toLatex();
}

Bredima.Container.Sum.prototype._repositionContent = function(ps) {
    var symbol = this.parts.symbol.getPreferredSize();
    this.width = Math.max((symbol.width + 4), ps[0].width, ps[1].width);
    this.top = symbol.top + ps[1].height;
    this.bottom = symbol.bottom + ps[0].height;

    this._resize();
    this.parts.symbol.setPos((this.width - symbol.width) / 2, ps[1].height);
    this.rows[1].setPos((this.width - ps[1].width) / 2, 0);
    this.rows[0].setPos((this.width - ps[0].width) / 2, ps[1].height + symbol.height);
}

/* ===============================
*/
/**
 * @class 積分
 * @extends Bredima.Container
 * @constructor
 * @param {Object} param オブジェクト構築共通パラメタ
 */
Bredima.Container.Integral = function(param) {
    this.__super__(param);
    this.add('symbol', new Bredima.Parts.Symbol(this.exp.bredima, 'mathint', this.row.level));
}

Bredima.util.inherit(Bredima.Container.Integral, Bredima.Container);

Bredima.util.setProperty(Bredima.Container.Integral, {
			     MML: 'msubsup',
			     rowCount: 2,
			     rowLevels: [2, 2],
			     verticalOrder: [1, 0]
			 });

Bredima.Exp.register(Bredima.Container.Integral, 'container', 'integral');

Bredima.Container.Integral.prototype._toMMLContent = function(expand) {
    return Bredima.util.addTag('mo', this.parts.symbol.toMML(expand)) + 
	Bredima.util.applySuper('_toMMLContent', this);
}

Bredima.Container.Integral.prototype.toLatex = function() {
    return this.parts.symbol.toLatex() +
	'_' + this.rows[0].toLatex() +
	'^' + this.rows[1].toLatex();
}

Bredima.Container.Integral.prototype._repositionContent = function(ps) {
    var symbol = this.parts.symbol.getPreferredSize();
    var center = (ps[1].bottom + ps[0].top) / 2
    this.width = symbol.width + Math.max(ps[0].width, ps[1].width) + 2;
    this.top = ps[1].top + Math.ceil(center);
    this.bottom = ps[0].bottom + Math.floor(center);

    this._resize();
    this.parts.symbol.setPos(2, this.top - symbol.top);
    this.rows[1].setPos(symbol.width + 2, 0);
    this.rows[0].setPos(symbol.width + 2, this.height - ps[0].height);
}

/* ===============================
*/
/**
 * @class 定積分後の区間
 * @extends Bredima.Container
 * @constructor
 * @param {Object} param オブジェクト構築共通パラメタ
 */
Bredima.Container.IntInterval = function(param) {
    this.__super__(param);
    this.add('open', new Bredima.Parts.Image('bracket_open.png'));
    this.add('close', new Bredima.Parts.Image('bracket_close.png'));
}

Bredima.util.inherit(Bredima.Container.IntInterval, Bredima.Container);

Bredima.util.setProperty(Bredima.Container.IntInterval, {
			     MML: 'msubsup',
			     rowCount: 3,
			     rowLevels: [0, 2, 2],
			     verticalOrder: [2, 1]
			 });

Bredima.Exp.register(Bredima.Container.IntInterval, 'container', 'intinterval');

Bredima.Container.IntInterval.prototype.liftCursorFrom = function(rowfactor, dir) {
    var order = this.orderOf(rowfactor.row);
    if(((order == 1) && (dir == 'up')) || ((order == 2) && (dir == 'down')))
	return Bredima.util.applySuper('liftCursorFrom', this, arguments);
    return false;
}

Bredima.Container.IntInterval.prototype._toMMLContent = function(expand) {
    return Bredima.util.addTag('mfenced', this.content.toMML(expand), 'open="[" close="]"') +
	Bredima.util.applySuper('_toMMLContent', this);
}

Bredima.Container.IntInterval.prototype.toLatex = function() {
    return '\\left[' + this.content.toLatex('nofence') + '\\right]' +
	'_' + this.rows[1].toLatex() +
	'^' + this.rows[2].toLatex();
}

Bredima.Container.IntInterval.prototype._repositionContent = function(ps) {
    var center = (ps[2].bottom + ps[1].top) / 2;
    var top = Math.max(ps[2].top + Math.ceil(center) - ps[0].top, 0);
    this.width = ps[0].width + Math.max(ps[1].width, ps[2].width) + 22;
    this.top = top + ps[0].top;
    this.bottom = Math.max(ps[0].bottom, ps[1].bottom + Math.floor(center));

    this._resize();
    this.parts.open.setSize(10, ps[0].height);
    this.parts.open.setPos(2, top);
    this.parts.close.setSize(10, ps[0].height);
    this.parts.close.setPos(ps[0].width + 12, top);
    this.content.setPos(12, top);
    this.rows[2].setPos(ps[0].width + 22, 0);
    this.rows[1].setPos(ps[0].width + 22, this.height - ps[1].height);
}

/* ===============================
*/
/**
 * @class 極限
 * @extends Bredima.Container
 * @constructor
 * @param {Object} param オブジェクト構築共通パラメタ
 */
Bredima.Container.Limit = function(param) {
    this.__super__(param);
    this.add('string', new Bredima.Parts.String('lim', this.row.getLevel()));
}

Bredima.util.inherit(Bredima.Container.Limit, Bredima.Container);

Bredima.util.setProperty(Bredima.Container.Limit, {
			     MML: 'munder',
			     tex: 'lim_',
			     rowLevels: [2]
			 });

Bredima.Exp.register(Bredima.Container.Limit, 'container', 'lim');

Bredima.Container.Limit.prototype._toMMLContent = function(expand) {
    return Bredima.util.addTag('mi', 'lim') + this.content.toMML(expand);
}

Bredima.Container.Limit.prototype._repositionContent = function(ps) {
    var string = this.parts.string.getPreferredSize();
    this.width = Math.max(string.width, ps.width);
    this.top = string.top;
    this.bottom = string.bottom + ps.height;

    this._resize();
    this.parts.string.setPos((this.width - string.width) / 2, 0);
    this.content.setPos((this.width - ps.width) / 2, string.height);
}
