
/**
 * @class inputフォーム管理オブジェクト（mi, mo, mn相当）
 * @param {Object} param オブジェクト構築共通パラメタ
 * @extends Bredima.Token
 * @constructor
 */
Bredima.Token.Input = function(param) {
    this.__super__(param);
    var self = this;
    var exp = this.row.container.exp;

    this.obj.onfocus = function(evt) {
	exp.setFocus(self);
    }
    this.obj.onblur = function(evt) {
	exp.leaveFocus();
    }
    // ToDo 特殊なinputへの対応
    if(param.value) this.obj.value = param.value;
}

Bredima.util.inherit(Bredima.Token.Input, Bredima.Token);

Bredima.util.setProperty(Bredima.Token.Input, {
			     domName: 'textarea'
			 });

Bredima.Exp.register(Bredima.Token.Input, 'token', 'input');

/* ====================
 Token.Inputで定義
*/
/**
 * 指定した値と選択範囲にinputを初期化
 * @param {Object} arg 初期化内容を内包したオブジェクト value:文字, selction: 選択範囲
 */
Bredima.Token.Input.prototype.init = function(arg) {
    if(typeof(arg) == 'object') {
	this.obj.value = arg.value;
	this.selectRange(arg.selection);
    }
}

/**
 * inputの選択範囲を取得
 * @return Object Bredima.Range型
 */
Bredima.Token.Input.prototype.getSelection = function() {
    if(this.obj.selectionStart != null) {
	start = this.obj.selectionStart;
	end = this.obj.selectionEnd;
    }
    else {
	this.obj.focus();
	var docRange = document.selection.createRange();
	var textRange = document.body.createTextRange();
	textRange.moveToElementText(this.obj);
	
	var range = textRange.duplicate();
	range.setEndPoint('EndToStart', docRange);
	start = range.text.length;
	
	range = textRange.duplicate();
	range.setEndPoint('EndToEnd', docRange);
	end = range.text.length;
    }
    return new Bredima.Range(start, end);
}

/**
 * 選択位置でinputを分割、選択されていた値を返す
 */
Bredima.Token.Input.prototype.split = function(sel) {
    if(!sel) sel = this.getSelection();
    var txt = this.obj.value;
    this.obj.value = txt.substring(0, sel.start);
    var post = new Bredima.Token.Input({parent: this.row, value: txt.substring(sel.end)});
    this.row.add(post, this.getOrder() + 1);
    return {
	selectedValue : txt.substring(sel.start, sel.end),
	addedInput : post
    };
}

/**
 * 自分の前のInput（があれば）と併合
 */
Bredima.Token.Input.prototype.mergeWithPrevInput = function() {
    var order = this.getOrder();
    var prev = (order > 0) ? this.row.getRowfactor(order - 1) : '';
    if(prev && (prev.constructor.classID == 'input')) {
	var txt = prev.toString();
	this.obj.value = txt + this;
	this.row.remove(prev);
	this._setCursor(txt.length);
	return prev;
    }
}

/**
 * input内の特定の領域を選択
 * この後ブラウザを通じてonfocusが発生することに注意
 * @param {Object} range Bredima.Rangeオブジェクト
 */
Bredima.Token.Input.prototype.selectRange = function(range) {
    //ブラウザ依存判別
    if(this.obj.setSelectionRange) {
	this.obj.focus();
	this.obj.setSelectionRange(range.start, range.end);
    }
    else {
	var r2 = this.obj.createTextRange();
	r2.moveStart('character', range.start);
	r2.moveEnd('character', range.end - this.obj.value.length);
	r2.select();
    }
}

/**
 * input内のテキストを全選択
 */
Bredima.Token.Input.prototype.selectAll = function() {
    this.selectRange({start: 0, end: this.obj.value.length});
}

/**
 * selectRangeのエイリアス（Bredima.Rangeではなくて数値でカーソル位置を指定）
 * @param {Number} pos カーソルを置く位置
 * @private
 */
Bredima.Token.Input.prototype._setCursor = function(pos) {
    this.selectRange({start: pos, end: pos});
}

/* ====================
 Exp.Rowfactorの実装
*/

/**
 * input内の先頭か末尾にカーソルを置く
 * この後ブラウザを通じてonfocusが発生することに注意
 * @param {String} loc カーソルを置く位置 head /tail
 */
Bredima.Token.Input.prototype.setCursorTo = function(loc) {
    this._setCursor((loc == 'head') ? 0 : this.obj.value.length);
    return true;
}

Bredima.Token.Input.prototype.getIncomingInput = function() {
    return this;
}

/* ====================
 Expの実装
*/

/**
 * 自分のDOMオブジェクト内の値を文字列表記として返す
 */
Bredima.Token.Input.prototype.toString = function() { return this.obj.value; }

/**
 * 概要オブジェクトを返す
 * 頭にclassIDが不要なので関数をオーバーライド
 */
Bredima.Token.Input.prototype.toRundown = function() {
    return this.obj.value;
}

Bredima.Token.Input.prototype.toMML = function(expand) {
    return (this.obj.value == '') ? '' : Bredima.util.addTag('mi', this.obj.value); // 仮
}

Bredima.Token.Input.prototype.toLatex = function() {
    return this.obj.value;
}

Bredima.Token.Input.prototype._reposition = function() {
    var pos = this.getOrder();
    // どれかが当てはまれば最小化表示をしない
    var visible = (
	(this.row.container.exp.getCurrent() === this) || // フォーカスが自分に乗ってる
	(this.obj.value.length > 0) || // 中身がある
	(this.row.getLength() == 1) || // row内の要素が1つだけ
	// 自分が左端で、かつ右隣が左隣を必要とするもの（累乗）
	// 左端でなければ累乗とかは自分の左隣に作用しているものと仮定　(x+2)^2とか
	((pos == 1) && (this.row.getLength() > pos) && (this.row.getRowfactor(pos + 1).isNeedPrev)));
    if(visible) {
	this.removeClassNameSuffix();
	this.width = Math.floor((this.obj.value.length + 2) * Bredima.Token.width[this.row.level]);
	this._resizeWidth();
    }
    else {
	this.width = 4;
	this.obj.style.width = '';
	this.setClassNameSuffix('hidden');
    }
}

Bredima.style.add(
    ['.input', "border: 1px solid gray; margin: 0; text-align: left; overflow: hidden; resize: none;"],
    ['textarea.hidden', 'border-color: #ddd; background-color: #ddd; width: 4px;'],
    ['textarea.hidden:hover', 'border-color: gray;']
);
