
/**
 * @class トークン要素抽象クラス
 * @extends Bredima.Exp.Rowfactor
 * @constructor
 * @param {Object} param オブジェクト構築共通パラメタ
 */
Bredima.Token = function(param) {
    arguments.callee.superClass.apply(this, arguments);
    this.height = Bredima.Token.height[this.row.getLevel()];
    this.addClassName('token_level' + this.row.getLevel());
}

Bredima.util.inherit(Bredima.Token, Bredima.Exp.Rowfactor);

Bredima.Token.width = [0, 10, 7];
Bredima.Token.height = [0, 22,18];

/**
 * （継承先で使用）heightはスタイルシートの指定から変更がないのでwidthのみ変更
 * 
 */
Bredima.Token.prototype._resizeWidth = function() {
    this.obj.style.width = this.width + 'px';
}

/* -----------------
 Expの実装
 */
Bredima.Token.prototype._toLatexContent = function() {
    // シンボルのみなら基本的にコマンドのみ
    return '';
}

Bredima.style.add(
    ['.token', "border: 1px dashed darkturquoise; font-family: 'Courier New', monospace; text-align: center;"],
    ['.token_level1', 'font-size: 16px; height: 22px; line-height: 22px;'],
    ['.token_level2', 'font-size: 12px; height: 18px; line-height: 18px;'],
    ['.token .parts', 'position: static;']
);
Bredima.style.add(
);


/* ===========================
 サブクラス
*/
/**
 * @class mi/moオブジェクト
 * @extends Bredima.Token
 * @param {Object} param オブジェクト構築共通パラメタ
 * @param {Object} sid シンボルID 大抵はMathML名
 */
Bredima.Token.Symbol = function(param, sid) {
    this.__super__(param);
    this.symbolID = (sid) ? sid : ((param.rundown) ? param.rundown[0] : '');
    this.symbol = new Bredima.Parts.Symbol(this.row.container.exp.bredima, this.symbolID, this.row.level, 'fixsize');
    this.MML = (this.symbol.getGroup() == 'operator') ? 'mo' : 'mi';
    this.width = Bredima.Token.height[this.row.level];
    this.obj.appendChild(this.symbol.obj);

    this._resizeWidth();
}

Bredima.util.inherit(Bredima.Token.Symbol, Bredima.Token);

Bredima.Exp.register(Bredima.Token.Symbol, 'token', 'symbol');

/* ------------------
 Expの実装
 */
/**
 * 文字列表記としてシンボルのIDを返す
 * 概要オブジェクトの中身もこの値
 */
Bredima.Token.Symbol.prototype.toString = function() {
    return this.symbolID;
}

Bredima.Token.Symbol.prototype._toMMLContent = function(expand) {
    return this.symbol.toMML(expand);
}

Bredima.Token.Symbol.prototype.toLatex = function() {
    return this.symbol.toLatex();
}

/* ===========================
*/
/**
 * @class sinとか
 * @extends Bredima.Token
 * @param {Object} param オブジェクト構築共通パラメタ
 * @param {Strin} val 表示する文字列
 */
Bredima.Token.String = function(param, val) {
    this.__super__(param);
    this.value = (val) ? val : ((param.rundown) ? param.rundown[0] : '');
    this.tex = this.value;
    this.content = new Bredima.Parts.String(this.value, this.row.getLevel());
    this.width = this.content.width;
    this.obj.appendChild(this.content.getDom());
    
    this._resizeWidth();
}

Bredima.util.inherit(Bredima.Token.String, Bredima.Token);

Bredima.util.setProperty(Bredima.Token.String, {
    MML: 'mi'
});

Bredima.Exp.register(Bredima.Token.String, 'token', 'string');

Bredima.Token.String.prototype.toString = function() {
    return this.value;
}

