
/**
 * @class 横ライン部品
 * @constructor
 * @extends Bredima.Parts
 */
Bredima.Parts.Separator = function() {
    this.obj = document.createElement('div');
    this.__super__();
    this.addClassName('separator');
}

Bredima.util.inherit(Bredima.Parts.Separator, Bredima.Parts);

Bredima.style.add(
    ['.separator', 'background-color: black; height: 1px; font-size: 0; width: 100%;']
);
/* ----------------------------------------------
*/
/**
 * @class 画像部品
 * @constructor
 * @extends Bredima.Parts
 */
Bredima.Parts.Image = function(uri) {
    this.obj = new Image;
    this.__super__();
    this.setURI(uri);
    var self = this;
    this.obj.onload = function() {
	self.width = self.obj.width;
	self.height = self.obj.height;
    }
}

Bredima.util.inherit(Bredima.Parts.Image, Bredima.Parts);

/**
 * 画像のURIを変更
 * @param {String} ファイルのパス
 * @param {Boolean} imgディレクトリ以外を利用する場合は何か渡す
 */
Bredima.Parts.Image.prototype.setURI = function(uri, cnd) {
    var prefix = (cnd) ? '' : Bredima.config.get('uri_img');
    this.obj.src = prefix + uri;
}

/* ----------------------------------------------
*/
/**
 * @class 文字を格納したspan
 * @constructor
 * @extends Bredima.Parts
 * @param {String} str 文字
 * @param {Number} level 文字の大きさ
 */
Bredima.Parts.String = function(str, level) {
    this.obj = document.createElement('span');
    this.__super__();
    this.obj.appendChild(document.createTextNode(str));
    this.width = str.length * Bredima.Token.width[level];
    this.height = Bredima.Token.height[level];
}

Bredima.util.inherit(Bredima.Parts.String, Bredima.Parts);

/* ----------------------------------------------
*/
/**
 * ボタン
 * @constructor
 * @extends Bredima.Parts
 * @param {Object} parts 中身に入れるパーツ
 * @param {Function} func イベントハンドラ
 */
Bredima.Parts.Button = function(parts, func) {
    this.obj = document.createElement('button');
    this.__super__();
    //this.obj.type = 'button'; // IEで転けるので使わない
    this.parts = parts;
    this.obj.onclick = func;
    this.obj.appendChild(this.parts.getDom());
}

Bredima.util.inherit(Bredima.Parts.Button, Bredima.Parts);

/**
 * ボタンの有効/無効を変更
 * @param {Boolean} b 無効にする場合はtrue
 */
Bredima.Parts.Button.prototype.setDisabled = function(b) {
    this.obj.disabled = b;
    Bredima.util.setOpacity(this.parts.getDom(), (b) ? 0.4 : 1);
}

/* ----------------------------------------------
*/
/**
 * @class ポップアップメニュー表示ボタン
 * @constructor
 * @extends Bredima.Parts
 * @param {Object} bredima bredimaインスタンス
 * @param {String} name 表示するメニュー名
 */
Bredima.Parts.Popup = function(bredima, name, user) {
    this.obj = document.createElement('div');
    this.__super__();
    this.img = new Bredima.Parts.Image('btn_popup');
    this.obj.appendChild(this.img.getDom());
    this.width = 8;
    this.height = 8;
    this.user = user;
    var self = this;

    this.obj.onclick = function(evt) {
	bredima.menu.toggle(name, self, {left: 0, top: 8});
	Bredima.util.stopEvent(evt);
    }
}

Bredima.util.inherit(Bredima.Parts.Popup, Bredima.Parts);

/**
 * メニュー内の項目がクリックされた際の処理
 * @private
 */
Bredima.Parts.Popup.prototype.menuClickPerformed = function(number) {
    this.user.menuClickPerformed(number);
}   
