
/**
 * @class コンテナオブジェクト内で使用する小さいパーツ
 * @constructor
 */
Bredima.Parts = function() {
    this.setClassName(['parts']);
}

Bredima.util.setProperty(Bredima.Parts, { margin: 0 });

/**
 * 内部で管理しているDOMオブジェクト取得
 */
Bredima.Parts.prototype.getDom = function() {return this.obj; }

/**
 * パーツの位置を設定
 */
Bredima.Parts.prototype.setPos = function(left, top) {
    this.obj.style.left = left + 'px';
    this.obj.style.top = top + 'px';
}

/**
 * サイズを変更
 * @param {Number} width 幅
 * @param {Number} height 高さ
 */
Bredima.Parts.prototype.setSize = function(width, height) {
    Bredima.util.setSize(this.obj, width, height);
}

Bredima.Parts.prototype.setClassName = function(list) {
    this.className = (typeof list == 'string') ? new Array(list) : list.slice(0);
    this.obj.className = this.className.join(' ');
}

Bredima.Parts.prototype.addClassName = function(list) {
    this.className = this.className.concat(list);
    this.obj.className = this.className.join(' ');
}

Bredima.Parts.prototype.setClassNameSuffix = function(list) {
    this.suffix = list;
    var list2 = this.className.concat(list);
    this.obj.className = list2.join(' ');
}

Bredima.Parts.prototype.removeClassNameSuffix = function() {
    if(this.suffix) {
	this.suffix = '';
	this.obj.className = this.className.join(' ');
    }
}

/**
 * （継承先クラスで使用）自分の再配置
 * 自分のサイズをフィールド値に合わせて表示に反映
 */
Bredima.Parts.prototype._resize = function() {
    Bredima.util.setSize(this.obj, this.width, this.height);
}

/**
 * 表示に必要なサイズを返す
 */
Bredima.Parts.prototype.getPreferredSize = function() {
    return {
	top: (this.top != null) ? (this.top + this.margin) : (this.height / 2 + this.margin),
	bottom: (this.bottom != null) ? (this.bottom + this.margin) : (this.height / 2 + this.margin),
	height: this.height + this.margin * 2,
	width: this.width + this.margin * 2
    };
}

Bredima.style.add(
    ['.exproot .parts', 'position: absolute;']
);