
/**
 * @class パネル部品（divとパーツ管理）
 * @constructor
 * @extends Bredima.Parts
 */
Bredima.Panel = function(classname) {
    this.obj = document.createElement('div');
    if(classname) this.obj.className = classname;
    this.isVisible = true;
    //this.observer = new Bredima.Observer();
}

Bredima.util.inherit(Bredima.Panel, Bredima.Parts);

/**
 * 自身にパーツを登録
 * 登録したものは直接自分のフィールドに入る
 * @param {String} key フィールドの名前
 * @param {Object} child パーツ
 */
Bredima.Panel.prototype.add = function(child, key) {
    if(key) this[key] = child;
    this.obj.appendChild(child.getDom());
}

Bredima.Panel.prototype.addDom = function(dom, key) {
    if(typeof dom == 'string') dom = document.createElement(dom);
    if(key) this[key] = dom;
    this.obj.appendChild(dom);
}

/**
 * 表示する
 */
Bredima.Panel.prototype.show = function(arg) {
    this.obj.style.display = 'block';
    this.isVisible = true;
}
    
/**
 * 隠す
 */
Bredima.Panel.prototype.hide = function(arg) {
    this.obj.style.display = 'none';
    this.isVisible = false;
}

/**
 * 表示/非表示の切り替え
 */
Bredima.Panel.prototype.toggleVisibility = function(arg) {
    if(this.isVisible) {
	this.hide(arg);
	return 'hide';
    }
    else {
	this.show(arg);
	return 'show';
    }
}

/**
 * 表示状態を返す
 */
Bredima.Panel.prototype.getVisibility = function() {return this.isVisible; }

