
/**
 * @class ポップアップメニュー管理
 * @constructor
 */
Bredima.Menu = function(bredima) {
    this.bredima = bredima;
    var c;
    var m;
    this.menus = {};
    var self = this;
    for(var i = 0; i < this.table.length; i++) {
	c = this.table[i];
	m = new Bredima.Panel.Menu();
	for(var n = 0; n < c.content.length; n++){
	    m.addMenuItem(new Bredima.Parts.Image(c.content[n]));
	}
	this.menus[c.key] = m;
	m.hide();
	bredima.frame.add(m);
	m.observer.attach(this);
    }
    bredima.frame.eventObserver.attach(this);
}

Bredima.Menu.prototype.table = [
    {key: 'fenced', content: ['btn_fenced.png', 'btn_brace.png', 'btn_bracket.png']}
];

/**
 * ポップアップメニューの表示/非表示を切り替え
 * @param {String} name 名前
 * @param {Object} user 使用元/イベントハンドラ呼び出し先
 * @param {Object} position 表示位置
 */
Bredima.Menu.prototype.toggle = function(name, user, position) {
    if(!this.opened) {
	this._open(name, user, position);
    }
    else if((this.name == name) && (this.user == user)) {
	this._close();
    }
    else {
	this._close();
	this._open(name, user, position);
    }
}	

/**
 * メニューを開く
 * @private
 */
Bredima.Menu.prototype._open = function(name, user, position) {
    this.name = name;
    this.user = user;
    this.opened = this.menus[name];
    // positionは後でやろう
    var offset = Bredima.util.getOffset(user.getDom(), this.bredima.frame.getDom());
    this.opened.setPos(offset.left + position.left, offset.top + position.top);
    this.opened.show();
}

/**
 * メニューを閉じる
 * @private
 */
Bredima.Menu.prototype._close = function() {
    this.opened.hide();
    this.opened = '';
}

/**
 * メニューパネルのクリックを受信
 * @private
 */
Bredima.Menu.prototype.onMenuClick = function(arg) {
    this.user.menuClickPerformed(arg);
    this._close();
}

Bredima.Menu.prototype.onFrameClick = function() {
    if(this.opened) this._close();
}
