
/**
 * @class コンテナオブジェクト挿入ボタン管理オブジェクト
 * @constructor
 * @extends Bredima.Panel.Toolbar
 */
Bredima.Frame.Container = function(bredima) {
    this.__super__(bredima);
    this.initFromArray(Bredima.Frame.Container.order);
}

Bredima.util.inherit(Bredima.Frame.Container, Bredima.Panel.Toolbar);

/**
 * イベントリスナ関数を返す
 */
Bredima.Frame.Container.prototype.createListenerFunc = function(btn, bredima) {
    var classfunc;
    if(typeof(btn) == 'string') {
	classfunc = Bredima.Exp.getClassById(btn);
	return function(){
	    bredima.exp.insElement(function(rd){ return new classfunc(rd); });
	};
    }
    else {
	classfunc = Bredima.Exp.getClassById(btn.id);
	return function() {
	    bredima.exp.insElement(function(rd){ return new classfunc(rd, btn.arg); });
	};
    }
}

/**
 * ボタンの中身を返す
 */
Bredima.Frame.Container.prototype.createContent = function(btn, bredima) {
    if(typeof(btn) != 'string')
	btn = btn.id;
    return new Bredima.Parts.Image('btn_' + btn + '.png');
}


// やっぱり集中管理できた方が楽そうなのでここでボタンの列びを指定
Bredima.Frame.Container.order = [
    'frac', {id: 'fenced', arg: '0'}, 'sqrt', 'root', 'sup', 'sub'
];

/**
 * @class 識別子オブジェクト挿入ボタン管理オブジェクト
 * @constructor
 * @extends Bredima.Panel.Toolbar
 */
Bredima.Frame.Identifier = function(bredima) {
    this.__super__(bredima);
    this.initFromArray(Bredima.Frame.Identifier.order);
}

Bredima.util.inherit(Bredima.Frame.Identifier, Bredima.Panel.Toolbar);

Bredima.Frame.Identifier.prototype.createListenerFunc = function(name, bredima) {
    return function() {
	bredima.exp.insElement(function(p) {
				   return new Bredima.Token.Symbol(p, name);
			       });
    };
}

Bredima.Frame.Identifier.prototype.createContent = function(name, bredima) {
    return new Bredima.Parts.Symbol(bredima, name, 1, 'fixsize');
}

Bredima.Frame.Identifier.order = [
    'sdot', 'times'
];

/**
 * @class 操作ボタン管理オブジェクト
 * @constructor
 * @extends Bredima.Panel.Toolbar
 */
Bredima.Frame.Operation = function(bredima) {
    this.__super__(bredima);
    this.undo = new Bredima.Parts.Button(
	new Bredima.Parts.Image('btn_undo.png'),
	function() {bredima.history.undo(); });
    this.redo = new Bredima.Parts.Button(
	new Bredima.Parts.Image('btn_redo.png'),
	function() {bredima.history.redo(); });
    this.undo.setDisabled(true);
    this.redo.setDisabled(true);
    this.add(this.undo);
    this.add(this.redo);
    this.source = new Bredima.Parts.Button(
	new Bredima.Parts.Image('btn_source.png'),
	function() {bredima.frame.source.show(); });
    this.add(this.source);

    bredima.history.observer.attach(this);
}

Bredima.util.inherit(Bredima.Frame.Operation, Bredima.Panel.Toolbar);

/**
 * 履歴に変化があった場合の処理
 * @private
 */
Bredima.Frame.Operation.prototype.onHistoryEnableChange = function(name) {
    var btn = ((name.indexOf('undo') >= 0) ? this.undo : 
	       ((name.indexOf('redo') >= 0) ? this.redo : ''));
    if(btn) btn.setDisabled((name.indexOf('disable') >= 0) ? true : false);
}