
/* ------------------------
main.js
--必須のもの、onload関数

*グローバル関数
*ControlFunc - グローバル関数寄せ集め
*Const
*window.onload
*/

var Control;
var Root;

/* ====================
** 設定値
*/
function Config() {
}

// スクリプト中で勝手に書き換える
Config.isAddOn = false;
Config.isMML = false;

/* ====================
** グローバル関数
*/

// デバッグ用
function printCsl(str) {
    var Console = document.getElementById('console');
    Console.replaceChild(document.createTextNode(str), Console.firstChild);
}

/*
// 継承を実現するグローバル関数
function inherit(subClass, superClass) {
    printCsl('global "inherit" is called!');
    function tmp(){};
    tmp.prototype = superClass.prototype;
    subClass.prototype = new tmp();
    subClass.prototype.constructor = subClass;
}

// 既定のインスタンス変数を設定
function setProperties(currentClass, props) {
    for(var key in props) {
        currentClass.prototype[key] = props[key];
    }
}
*/
/* ====================
** グローバルにいろいろするクラス
*/
function ControlFunc() {
    this.idnum = 1;
    this.focusID = '';
    this.timeoutObj = ''; // グローバルから見えない場所からsetTimeoutを使用するとき用
    //this.dummyInput = document.getElementById('dummyInput');
    /*
    this.previewarea = document.getElementById('preview');
    if(!Config.isMML) {
        this.img = document.createElement('img');
        this.previewarea.appendChild(this.img);
    }
    */
    /*
    // ユニークなID番号を発行
    this.issueID = function() {
        return this.idnum++;
    }
    */
    // 現在フォーカスがある場所を登録する
    /*
    this.submitFocus = function(obj, id) {
	var prevObj = this.focusObj;
        this.focusObj = obj;
        this.focusID = id;
	if(prevObj) {
	    prevObj.setIsHide();
	    prevObj.layout();
	}
	this.focusObj.isHidden = false;
	this.focusObj.layout();
    }
    */
    /*
    // 自動プレビュー処理
    this.updatePreview = function() {
        if(document.getElementById('check_livepreview').checked) {
            clearTimeout(this.previewTimeout);
            this.previewTimeout = setTimeout('Control.preview()', 500);
        }
    }
    
    // プレビュー
    this.preview = function() {
        if(Config.isMML == true) {
            this.previewarea.innerHTML = Root.outputMathML(true);
        }
        else{
            this.img.src = encodeURI(Const.mimeTexURI + Const.backslash + 'Large ' + Root.outputLatex());
        }
    }
    */
    // 位置を動かす
    this.setPosition = function(obj, left, top) {
        obj.style.left = left + 'px';
        obj.style.top = top + 'px';
    }
    
    // 大きさを変更する
    this.setSize = function(obj, width, height) {
        obj.style.width = width + 'px';
        obj.style.height = height + 'px';
    }
    
    // タグ付けする
    this.applyTag = function(tag, content) {
        return '<' + tag + '>' + content + '</' + tag + '>';
    }
    
    // ボタンを置く
    this.setupButton = function() {
        var mis = new SymbolButtons('identifier', Symbol.identifiers);
        var mos = new SymbolButtons('operator', Symbol.operators);
    }

}

/* ====================
** 定数クラス
*/
function Const() {
}

Const.version = '0.3.20060806';
Const.imgDir = 'img/';
Const.containerImgDir = 'button/';
Const.rowSpacing = 6;
Const.entity = new Object;
//Const.mimeTexURI = 'mimetex.cgi?';
Const.backslash = '\\';
Const.tokenWidth = [0, 10, 7];
Const.tokenHeight = [0, 22, 18];
//Const.tokenMimeSize = ['', 'large', 'normal'];
//Const.containerButtonSize = [36, 26];

/* ====================
** main
*/
onload = function() {
    
    // グローバルインスタンス作成
    Control = new ControlFunc();
    //Root = new MathFormulaContainer(document.getElementById('formula'));
    
    // 文字実体参照登録
/*
    var ents = document.getElementById('entityReferences').getElementsByTagName('span');
    for(var i = 0; i < ents.length; i++) {
        var entid = ents[i].id.substring(ents[i].id.indexOf('_') + 1);
        Const.entity[entid] = ents[i].firstChild.nodeValue;
    }
*/
    // ボタン作成
    //var containerbuttons = new ContainerButtons();
    //Symbol.setupSymbols();


    var b1 = new Bredima();
    b1.setConfig('locale', 'ja');
    b1.setConfig('isMML', false);
    b1.write(document.getElementById('bredima_1'));

    var b2 = new Bredima();
    b2.setConfig('locale', 'en');
    b2.setConfig('isMML', false);
    b2.write(document.getElementById('bredima_2'));

    
    // ソース出力部管理オブジェクト生成
    //var sourcearea = new SourceArea();

    // バージョン埋め込み
    document.getElementById('version').appendChild(document.createTextNode('version ' + Const.version));

    // プレビューボタンハンドラ設定
    /*
    document.getElementById('button_preview').onmouseup = function() {
        Control.preview();
    }
*/
    // アドオン用のボタン設定
    if(Config.isAddOn == true) {
	var additions = new AddOn();
    }

    
}

/* ====================
** onloadの置き換え狙いのメインクラス
*/

function Bredima() {
    this.serial = Bredima.serial++;
    
    // 初期設定から設定をコピー
    this.config = new Array();
    for(var key in Bredima.initialValue) {
	this.config[key] = Bredima.initialValue[key];
    }

}

Bredima.serial = 0;

Bredima.initialValue = {
    'uri_mimetex' : 'mimetex.cgi',
    'uri_img' : 'img/',
    'isMML' : false,
    'locale' : 'ja'
};

Bredima.initialized = false;
Bredima.initialize = function(bd) {
    if(Bredima.initialized) return;
    Bredima.initialized = true;
    BSymbol.initialize(bd);
}

Bredima.setInitialValue = function(key, val) {
    if(Bredima.serial > 0) return;
    for(var v in Bredima.initialValue) {
	if(v == key) {
	    Bredima.initialValue[key] = val;
	}
    }
}

Bredima.prototype.setConfig = function(key, val) {
    for(var v in this.config) {
	if(v == key) {
	    this.config[key] = val;
	}
    }
}

Bredima.prototype.write = function(dom) {
    this.locale = new BLocale(this);
    this.mimetex = new BUtil.MimeTex(this);
    Bredima.initialize(this);
    this.frame = new BFrame(this, dom);
    this.exp = new BExpression(this, this.frame.exp);

    // 数式更新のタイミングでプレビューのアップデートをnotify
    var self = this;
    this.exp.observer.attach(function(){self.frame.preview.updatePreview();});
}
