// Cross Browser selectionStart/selectionEnd
// Version 0.1
// Copyright (c) 2005 KOSEKI Kengo
// 
// This script is distributed under the MIT licence.
// http://www.opensource.org/licenses/mit-license.php

function Selection(textareaElement, tgt) {
    this.element = textareaElement;
	this.targetDoc = (tgt != null) ? tgt : document;
}

Selection.prototype.create = function() {
    if (document.selection != null && this.element.selectionStart == null) {
        return this._ieGetSelection();
    } else {
        return this._mozillaGetSelection();
    }
}

Selection.prototype._mozillaGetSelection = function() {
    return { 
        start: this.element.selectionStart, 
        end: this.element.selectionEnd 
    };
}

Selection.prototype._ieGetSelection = function() {
    this.element.focus();

    var range = this.targetDoc.selection.createRange();
    var bookmark = range.getBookmark();

    var contents = this.element.value;
    var originalContents = contents;
    var marker = this._createSelectionMarker();
    while(contents.indexOf(marker) != -1) {
        marker = this._createSelectionMarker();
    }
    var selection = range.text;

    var parent = range.parentElement();
    if (parent == null || parent.type != "textarea") {
        return { start: 0, end: 0 };
    }
    range.text = marker + range.text + marker;
    contents = this.element.value;

    var result = {};
    result.start = contents.indexOf(marker);
    contents = contents.replace(marker, "");
    result.end = contents.indexOf(marker);

    this.element.value = originalContents;
	if(result.start != originalContents.length) {
      range.moveToBookmark(bookmark);
      range.select();
	}

    return result;
}

Selection.prototype._createSelectionMarker = function() {
    return "##SELECTION_MARKER_" + Math.random() + "##";
}

/* === 付け加え === */

Selection.prototype.setSelection = function(start, end) {
    if (document.selection != null && this.element.selectionStart == null) {
        this._ieSetSelection(start, end);
    } else {
        this._mozillaSetSelection(start, end);
    }
}

Selection.prototype.setCursor = function(num) {
	this.setSelection(num, num);
}
Selection.prototype.selectAll = function() {
	this.setSelection(0, this.element.value.length);
}

Selection.prototype._ieSetSelection = function(bn, en) {
	var range = this.element.createTextRange();
	range.moveStart("character", bn);
	range.moveEnd("character",en - this.element.value.length);
	range.select();
}

Selection.prototype._mozillaSetSelection = function(bn, en) {
	this.element.focus();
	this.element.setSelectionRange(bn, en);
}

