
/* ------------------------
Frame.js
-- BrEdiMaの全体のフレームを管理

*/

/* ====================
** 
*/
function BFrame(bredima, dom) {
    this.bredima = bredima;
    this.obj = dom;
    this.obj.className += ' BrEdiMa_Frame';

    this.container = new BFrame.Container(bredima, this);
    this.exp = document.createElement('div');
    this.obj.appendChild(this.exp);
    this.preview = new BFrame.Preview(bredima, this);
    this.source = new BFrame.Source(bredima, this);

    this.tmpDiv = document.createElement('div');
    //this.tmpDiv.style.visibility = 'hidden';
    this.obj.appendChild(this.tmpDiv);
    
    if(BSymbol.initialized) {
	this._setupSymbolButton();
    }
    else {
	var self = this;
	BSymbol.observer.attach(function() {self._setupSymbolButton()});
    }
}

BFrame.prototype._setupSymbolButton = function() {
    this.identifier = new BFrame.Symbol(this.bredima, this, 'identifier', BSymbol.identifiers);
    this.operetor = new BFrame.Symbol(this.bredima, this, 'operator', BSymbol.operators);
}

BUtil.style.add(
    [['.function_button', 'border: 1px solid gray; cursor: default; background-color: #ddd;']]
);

/* ====================
** コンテナオブジェクト挿入ボタン
*/
BFrame.Container = function(bredima, frame) {
    this.bredima = bredima;
    this.obj = document.createElement('div');
    this.obj.className = 'buttons container_buttons';
    this.buttons = new Array;
    var count = 0;
    var self = this;
    for(var i = 0; i < BFrame.containers.length; i++) {
        if(BFrame.containers[i] != null) {
        var btn = BFrame.containers[i];
            var obj = document.createElement('div');
            obj.className = 'container_button';
            obj.id = 'containerbutton' + bredima.serial + '_' + i;
            obj.onclick = function() {
                self._onClick(this);
            }
            BUtil.obj.setSize(obj, BFrame.Container.buttonSize[0] + 4, BFrame.Container.buttonSize[1] + 2);
            var img = document.createElement('img');
            img.src = bredima.config['uri_img'] + 'btn_' + btn.name + '.png';
            obj.appendChild(img);
            this.obj.appendChild(obj);
            BUtil.obj.setPos(obj, count++ * (BFrame.Container.buttonSize[0] + 8), 0);
        }
    }
    frame.obj.appendChild(this.obj);
}

BFrame.Container.buttonSize = [36, 26];

BFrame.containers = new Array;

BFrame.btnSubmit = function(tid, tname, tfunc) {
    BFrame.containers[tid] = {name: tname, func: tfunc};
}

BFrame.Container.prototype._onClick = function(btn) {
    var i = btn.id.substring(btn.id.indexOf('_') + 1);
    this.bredima.exp.insert(BFrame.containers[i].func);
}

BUtil.style.add(
    [['div.buttons', 'position: relative;'],  // ボタンまとめdiv全てに適用
     ['div.container_buttons', 'height: 30px;'],
     ['div.container_button', 'border: 1px solid gray; position: absolute; text-align: center;'],
     ['div.container_button img', 'margin: 1px;']
    ]
);

/* ====================
** トークンオブジェクト挿入ボタン
*/
BFrame.Symbol = function(bredima, frame, type, syms) {
    this.bredima = bredima;
    this.type = type;
    this.obj = document.createElement('div');
    this.obj.className = 'buttons symbol_buttons';
    this.buttons = new Array;
    this.level = 1;
    var self = this;
    var i = 0;
    for(var sym in syms) {
        var obj = document.createElement('div');
        obj.className = 'function_button symbol';
        obj.id = 'button' + bredima.serial + '_' + sym;
        obj.onclick = function() {
            self._onClick(this);
        }
        var symbol = new BSymbol(this, sym, true);
        this.buttons.push(symbol);
        obj.appendChild(symbol.obj);
        this.obj.appendChild(obj);
        BUtil.obj.setSize(obj, BExpToken.height[1] + 2, BExpToken.height[1] + 2);
        BUtil.obj.setPos(obj, i++ * (BExpToken.height[1] + 6), 0);
    }
    frame.obj.appendChild(this.obj);
}

BFrame.Symbol.prototype._onClick = function(btn) {
    var bid = btn.id.substring(btn.id.indexOf('_') + 1);
    var type = this.type;
    this.bredima.exp.insert(function(w){return new MathSymbol(w, bid, type)});
}
    
BUtil.style.add(
    [['div.symbol_buttons', 'height: 24px; margin: 4px 0px;']]
);

/* ====================
** ソース表示部
*/
BFrame.Source = function(bredima, frame) {
    this.bredima = bredima;
    this.frame = frame;
    var self = this;
    this.isVisible = false;

    this.obj = document.createElement('div');
    var t = document.createElement('input');
    t.type = 'button';
    t.className = 'function_button';
    //t.id = 'button_showmathml_' + this.bredima.serial;
    t.value = bredima.locale.text['show_mathml'];
    this.obj.appendChild(t);
    this.showmml = t;
    t = document.createElement('input');
    t.type = 'button';
    t.className = 'function_button';
    //t.id = 'button_showlatex_' + this.bredima.serial;
    t.value = bredima.locale.text['show_latex'];
    this.obj.appendChild(t);
    this.showlatex = t;
    t = document.createElement('textarea');
    t.className = 'source';
    //t.id = 'sourceOutput';
    this.obj.appendChild(t);
    this.output = t;

    frame.obj.appendChild(this.obj);

    this.showmml.onmouseup = function() {
	self.put(bredima.exp.outputMathML(false));
    }
    this.showlatex.onmouseup = function() {
	self.put(bredima.exp.outputLatex());
    }
}

BFrame.Source.prototype.put = function(str) {
    if(this.isVisible == false) {
	this.output.style.display = 'block';
	this.isVisible = true;
	this.height = 1;
	var self = this;
	this.timer = setInterval(function() {
				     if(self.height > 10) {
					 clearInterval(self.timer);
				     }
				     else {
					 self.output.style.height = self.height + 'em';
					 self.height += 3;
				     }
				 }, 60);
    }
    this.output.value = str;
}

BUtil.style.add(
    [['textarea.source', 'display: none; width: 70%; height: 1em;']]
);

/* ====================
** 数式プレビュー
*/
BFrame.Preview = function(bredima, frame) {
    var self = this;
    this.bredima = bredima;

    this.obj = document.createElement('div');
    var t = document.createElement('input');
    t.type = 'button';
    t.className = 'function_button';
    //t.id = 'button_preview_' + bredima.serial;
    t.value = bredima.locale.text['preview'];
    this.obj.appendChild(t);
    this.button = t;
    t = document.createElement('input');
    t.type = 'checkbox';
    //t.id = 'check_livepreview_' + bredima.serial;
    this.obj.appendChild(t);
    this.livecheck = t;
    t = document.createTextNode(bredima.locale.text['live_preview']);
    this.obj.appendChild(t);
    t = document.createElement('div');
    t.className = 'preview_window';
    this.obj.appendChild(t);
    this.display = t;
    
    frame.obj.appendChild(this.obj);

    if(!bredima.config.isMML) {
	this.img = document.createElement('img');
	this.display.appendChild(this.img);
    }

    this.button.onmouseup = function() {
	self.preview();
    }	
}

BFrame.Preview.prototype.preview = function() {
    if(this.bredima.config.isMML) {
	this.display.innerHTML = this.bredima.exp.outputMathML(true);
    }
    else {
	this.img.src = this.bredima.mimetex.getURI(this.bredima.exp.outputLatex(), 'Large');
    }
}

BFrame.Preview.prototype.updatePreview = function() {
    if(this.livecheck.checked) {
	clearTimeout(this.timer);
	var self = this;
	this.timer = setTimeout(function() {self.preview();}, 500);
    }
}

BUtil.style.add(
    [['div.preview_window', 'padding: 10px']]
);
