

/* ====================
** 式を入力する部分の管理。表示領域の管理はFrameにやってもらう（つもり）
*/
function BExpression(bredima, dom) {
    this.bredima = bredima;
    this.obj = dom;
    this.exp = this;
    this.observer = new BUtil.Observer();

    this.issuedSerial = 1;
    this.focusID = '';
    this.focusObj = '';

    this.content = new MathRow(this, 1);
    dom.appendChild(this.content.obj);
    
    this.content.setInitialValue('');
}

// ルートなのでこれ以上カーソル移動はなし
BExpression.prototype.backCursor = function() {
}
BExpression.prototype.fwdCursor = function() {
}

// 入力中の数式が変更されたことを通知
BExpression.prototype.layout = function() {
    this.observer.notify('update');
}

// 式全体のMathMLコード書き出し
BExpression.prototype.outputMathML = function(expand) {
    var out = '<math xmlns="http://www.w3.org/1998/Math/MathML" display="block">' + "\n";
    out += this.content.outputMathML(expand);
    out += '</math>' + "\n";
    return out;
}

// 式全体のLaTeXコード書き出し
BExpression.prototype.outputLatex = function() {
    return this.content.outputLatex(true);
}

BExpression.prototype.getExp = function() {
    return this;
}

// 1つのBredimaオブジェクト内での通し番号発行
BExpression.prototype.issueSerial = function() {
    return this.issuedSerial++;
}

// 1つのBredimaオブジェクト内でのID発行
BExpression.prototype.issueID = function(ist) {
    ist.obj.id = ist.objType + '_' + this.issueSerial() + '_' + this.bredima.serial;
    return ist.obj.id;
}

// 式内のInput要素のフォーカス管理
BExpression.prototype.submitFocus = function(obj, id) {
    var prevObj = this.focusObj;
    this.focusObj = obj;
    this.focusID = id;
    if(prevObj) {
	prevObj.setIsHide();
	prevObj.layout();
    }
    this.focusObj.isHidden = false;
    this.focusObj.layout();
}

BExpression.prototype.insert = function(func) {
    this.focusObj.insert(func(this.focusObj.wrap));
}
