
/* ------------------------
Container2.js
-- コンテナオブジェクトでレイアウトのみにMathML要素を使用するもの

*MathOver - mover - オーバーライン, ベクトル, 弧
*MathPermutation - mmultiscripts - 順列, 組合せ, 重複組合せ
*MathSum - munderover - 総和
*MathIntegral - msubsup - 積分
*MathInterval - msubsup - 定積分後の区間表示
*MathLimit - munder - 極限
*/

/* ====================
** オーバーライン（\overline）
*/
function MathOver(par) {
    this.__super__(par);

    this.overline = new Separator();
    this.obj.appendChild(this.overline.obj);
    this._layout();
}

BUtil.inherit(MathOver, BExpContainer);

BUtil.setProperty(MathOver, {
    objType: 'over',
    rowCount: 1,
    mathmlTag: 'mover',
    texCommand: 'overline'
});

ContainerButtons.submit(31, 'over', function(wrap){return new MathOver(wrap);});

// MathMLコード書き出し
MathOver.prototype.outputMathML = function(expand) {
    var out = this.content.outputMathML(expand);
    out += '<mo>';
    out += (expand) ? BSymbol.all['OverBar'].code : '&OverBar;';
    out += '</mo>';
    return this._tagMML(out);
}

// 表示部品削除
MathOver.prototype.removeObj = function() {
    this.overline.removeObj();
    this._removeObj();
}

// ---------- private
MathOver.prototype._layout = function() {
    this._setLayout(4, 2, 0, 2);
    //this._calcPosition(4, 0, 4);
    //Control.setSize(this.obj, this.width, this.height);
    //Control.setPosition(this.content.obj, 2, 4);
    BUtil.obj.setSize(this.overline.obj, this.width, 1);
    BUtil.obj.setPos(this.overline.obj, 0, 2);
}

/* ====================
** 順列, 組み合わせ（<mmultiscripts>）
*/
function MathPermutation(par, kind) {
    this.__super__(par, [2, 2]);
    this.value = MathPermutation.values[kind];
    this.level = this.wrap.level;
    this.symbol = new StringSpan(this, this.value);
    this.obj.appendChild(this.symbol.obj);
    this._layout();
}

MathPermutation.values = {
    permutation: 'P',
    combination: 'C',
    homogeneous: 'H'
};

BUtil.inherit(MathPermutation, BExpContainer);

BUtil.setProperty(MathPermutation, {
    objType: 'permutation',
    rowCount: 2,
    mathmlTag: 'mmultiscripts'
});

ContainerButtons.submit(101, 'permutation', function(wrap){return new MathPermutation(wrap, 'permutation');});

// MathMLコード書き出し
MathPermutation.prototype.outputMathML = function(expand) {
    var ret = Control.applyTag('mi', this.value) + "\n";
    ret += this.rows[1].outputMathML();
    ret += '<none/>' + "\n";
    ret += '<mprescripts/>' + "\n";
    ret += this.rows[0].outputMathML();
    ret += '<none/>' + "\n";
    return this._tagMML(ret);
}

// LaTeXコード書き出し
MathPermutation.prototype.outputLatex = function() {
    return '{{}_' + this.rows[0].outputLatex() + this.value + '_' + this.rows[1].outputLatex() + '}';
}

// 表示部品削除
MathPermutation.prototype.removeObj = function() {
    this.symbol.removeObj();
    this._removeObj();
}

// コンテナ内配置
MathPermutation.prototype._layout = function() {
    // 計算して保存
    var psymbol = this.symbol.getPreferredSize();
    var pleft = this.rows[0].getPreferredSize();
    var pright = this.rows[1].getPreferredSize();
    this.width = pleft.width + psymbol.width + pright.width + 8;
    this.top = psymbol.top;
    this.bottom = Math.max(Math.max(pleft.height, pright.height), psymbol.bottom) + 2;
    this.height = this.top + this.bottom;
    // 適用
    this._setSize();
    BUtil.obj.setPos(this.symbol.obj, pleft.width + 4, 0);
    BUtil.obj.setPos(this.rows[0].obj, 2, this.top);
    BUtil.obj.setPos(this.rows[1].obj, pleft.width + psymbol.width + 6, this.top);
}

/* ====================
** 総和（<munderover>）
*/

function MathSum(par) {
    this.__super__(par, [2, 2]);

    this.level = this.wrap.level;
    this.symbol = new BSymbol(this, 'sum');
    this.obj.appendChild(this.symbol.obj);
    this._layout();
}

BUtil.inherit(MathSum, BExpContainer);

BUtil.setProperty(MathSum, {
    objType: 'sum',
    rowCount: 2,
    mathmlTag: 'munderover',
    texCommand: 'sum'
});

ContainerButtons.submit(41, 'sum', function(wrap){return new MathSum(wrap);});

// MathMLコード書き出し
MathSum.prototype.outputMathML = function(expand) {
    var ret = Control.applyTag('mo', this.symbol.getMathML(expand));
    ret += "\n";
    ret += this.rows[0].outputMathML(expand);
    ret += this.rows[1].outputMathML(expand);
    return this._tagMML(ret);
}

// LaTeXコード書き出し
MathSum.prototype.outputLatex = function() {
    return this.symbol.getLatex() + '_' + this.rows[0].outputLatex() + '^' + this.rows[1].outputLatex();
}

// 表示部品削除
MathSum.prototype.removeObj = function() {
    this.symbol.removeObj();
    this._removeObj();
}

// コンテナ内配置
MathSum.prototype._layout = function() {
    // 計算して保存
    var psymbol = this.symbol.getPreferredSize();
    var punder = this.rows[0].getPreferredSize();
    var pover = this.rows[1].getPreferredSize();
    this.width = Math.max(Math.max(punder.width, pover.width), psymbol.width);
    this.top = psymbol.top + pover.height;
    this.bottom = psymbol.bottom + punder.height;
    this.height = this.top + this.bottom;
    // 適用
    this._setSize();
    BUtil.obj.setPos(this.symbol.obj, (this.width - psymbol.width) / 2, pover.height);
    BUtil.obj.setPos(this.rows[0].obj, (this.width - punder.width) / 2, pover.height + psymbol.height);
    BUtil.obj.setPos(this.rows[1].obj, (this.width - pover.width) / 2, 0);
}


/* ====================
** 積分（<msubsup>）
*/

function MathIntegral(par) {
    this.__super__(par, [2, 2]);

    this.level = this.wrap.level;
    this.symbol = new BSymbol(this, 'math_int');
    this.obj.appendChild(this.symbol.obj);
    this._layout();
}

BUtil.inherit(MathIntegral, BExpContainer);

BUtil.setProperty(MathIntegral, {
    objType: 'int',
    rowCount: 2,
    mathmlTag: 'msubsup',
    texCommand: 'int'
});

ContainerButtons.submit(51, 'integral', function(wrap){return new MathIntegral(wrap);});

// MathMLコード書き出し
MathIntegral.prototype.outputMathML = function(expand) {
    var ret = Control.applyTag('mo', this.symbol.getMathML(expand));
    ret += "\n";
    ret += this.rows[0].outputMathML(expand);
    ret += this.rows[1].outputMathML(expand);
    return this._tagMML(ret);
}

// LaTeXコード書き出し
MathIntegral.prototype.outputLatex = function() {
    return this.symbol.getLatex() + '_' + this.rows[0].outputLatex() + '^' + this.rows[1].outputLatex();
}

// 表示部品削除
MathIntegral.prototype.removeObj = function() {
    this.symbol.removeObj();
    this._removeObj();
}

// コンテナ内配置
MathIntegral.prototype._layout = function() {
    // 計算して保存
    var psymbol = this.symbol.getPreferredSize();
    var punder = this.rows[0].getPreferredSize();
    var pover = this.rows[1].getPreferredSize();
    this.width = psymbol.width + Math.max(punder.width, pover.width) + 4;
    this.top = pover.top + (pover.bottom + punder.top) / 2 
    this.bottom = punder.bottom + (pover.bottom + punder.top) / 2 
    this.height = this.top + this.bottom;
    // 適用
    this._setSize();
    BUtil.obj.setPos(this.symbol.obj, 0, this.top - psymbol.top);
    BUtil.obj.setPos(this.rows[0].obj, psymbol.width + 4, this.height - punder.height);
    BUtil.obj.setPos(this.rows[1].obj, psymbol.width + 4, 0);
}


/* ====================
** 定積分後の区間（<msubsup>）
*/

function MathInterval(par) {
    this.__super__(par, [par.level, 2, 2]);
    // 開き括弧画像
    this.imgOpen = document.createElement('img');
    this.imgOpen.src = Const.imgDir + 'openBracket.png';
    this.imgOpen.className = 'containerParts';
    this.obj.appendChild(this.imgOpen);
    // 閉じ括弧画像
    this.imgClose = document.createElement('img');
    this.imgClose.src = Const.imgDir + 'closeBracket.png';
    this.imgClose.className = 'containerParts';
    this.obj.appendChild(this.imgClose);
    this._layout();
}

BUtil.inherit(MathInterval, BExpContainer);

BUtil.setProperty(MathInterval, {
    objType: 'interval',
    rowCount: 3,
    mathmlTag: 'msubsup'
});

ContainerButtons.submit(52, 'interval', function(wrap){return new MathInterval(wrap);});

// MathMLコード書き出し
MathInterval.prototype.outputMathML = function(expand) {
    var out = '<mfenced open="[" close="]">' + "\n";
    out += this.content.outputMathML(expand);
    out += '</mfenced>' + "\n";
    out += this.rows[1].outputMathML(expand);
    out += this.rows[2].outputMathML(expand);
    return this._tagMML(out);
}

// LaTeXコード書き出し
MathInterval.prototype.outputLatex = function() {
    var out = Const.backslash + 'left[';
    out += this.content.outputLatex(true);
    out += Const.backslash + 'right]';
    out += '_' + this.rows[1].outputLatex();
    out += '^' + this.rows[2].outputLatex();
    return out;
}

// 表示部品削除
MathInterval.prototype.removeObj = function() {
    this.obj.removeChild(this.imgOpen);
    this.obj.removeChild(this.imgClose);
    this._removeObj();
}

// コンテナ内配置
MathInterval.prototype._layout = function() {
    // 計算して保存
    var pcontent = this.content.getPreferredSize();
    var punder = this.rows[1].getPreferredSize();
    var pover = this.rows[2].getPreferredSize();
    this.width = pcontent.width + Math.max(punder.width, pover.width) + 24;
    this.top = pover.top + (pover.bottom + punder.top) / 2;
    this.bottom = punder.bottom + (pover.bottom + punder.top) / 2;
    this.top = Math.max(this.top, pcontent.top);
    this.bottom = Math.max(this.bottom, pcontent.bottom);
    this.height = this.top + this.bottom;
    // 適用
    this._setSize();
    BUtil.obj.setPos(this.content.obj, 12, this.top - pcontent.top);
    BUtil.obj.setSize(this.imgOpen, 10, pcontent.height);
    BUtil.obj.setPos(this.imgOpen, 0, this.top - pcontent.top);
    BUtil.obj.setSize(this.imgClose, 10, pcontent.height);
    BUtil.obj.setPos(this.imgClose, pcontent.width + 14, this.top - pcontent.top);
    BUtil.obj.setPos(this.rows[2].obj, pcontent.width + 24, 0);
    BUtil.obj.setPos(this.rows[1].obj, pcontent.width + 24, this.height - punder.height);
}


/* ====================
** 極限（<munder>）
*/
function MathLimit(par) {
    this.__super__(par, [2]);
    this.level = this.wrap.level;
    this.string = new StringSpan(this, 'lim');
    this.obj.appendChild(this.string.obj);
    this._layout();
}

BUtil.inherit(MathLimit, BExpContainer);

BUtil.setProperty(MathLimit, {
    objType: 'limit',
    rowCount: 1,
    mathmlTag: 'munder',
    texCommand: 'lim_'
});

// MathMLコード書き出し
MathLimit.prototype.outputMathML = function(expand) {
    var ret = Control.applyTag('mi', 'lim') + "\n";
    ret += this.content.outputMathML(expand);
    return this._tagMML(ret);
}

// 表示部品削除
MathLimit.prototype.removeObj = function() {
    this.string.removeObj();
    this._removeObj();
}

// コンテナ内配置
MathLimit.prototype._layout = function() {
    // 計算して保存
    var pstring = this.string.getPreferredSize();
    var pcontent = this.content.getPreferredSize();
    this.width = Math.max(pstring.width, pcontent.width) + 4;
    this.top = pstring.top;
    this.bottom = pstring.bottom + pcontent.height;
    this.height = this.top + this.bottom;
    // 適用
    this._setSize();
    BUtil.obj.setPos(this.string.obj, (this.width - pstring.width) / 2, 0);
    BUtil.obj.setPos(this.content.obj, (this.width - pcontent.width) / 2, pstring.height - 1);
}

