using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Net;
using System.Text;
using System.Threading;
using System.Text.RegularExpressions;
using System.Windows.Forms;

using Boon.Controls.Browsers;
using Boon.Collections;
using Boon.Net;
using Boon.IO.File;
using Boon.Forms.Dialog;
using Boon.Win32;

using HttpService.API;
using HttpService.API.Request;

using XmlSerializer = System.Xml.Serialization.XmlSerializer;
using XmlTextReader = System.Xml.XmlTextReader;
using XmlTextWriter = System.Xml.XmlTextWriter;


namespace Boon.Forms
{
    public partial class MainForm : Form
    {
		const string appTitle = "Ԃ񂷂IȂԂ炤";
		readonly string favoriteFilePath = Application.StartupPath + "\\favorite.xml";

        /// <summary>
        /// ݒێBoonSerializableConfigIuWFNgłB
        /// </summary>
        private BoonSerializableConfig boonConfig_ = BoonSerializableConfig.getInstance();


		#region Group : Constructor / Initializers

		/// <summary>
        /// RXgN^łB
        /// </summary>
        public MainForm()
        {
			if(this.boonConfig_.isProxyUse)
			{
				Urlmon.InternetOptionProxy(InternetOpenType.INTERNET_OPEN_TYPE_DIRECT);
			}
			else if(this.boonConfig_.isDefaultProxy)
			{
				Urlmon.InternetOptionProxy(InternetOpenType.INTERNET_OPEN_TYPE_PRECONFIG);
			}
			else
			{
				Urlmon.InternetOptionProxy(InternetOpenType.INTERNET_OPEN_TYPE_PROXY, this.boonConfig_.proxyAddress + ":" + this.boonConfig_.proxyPort, "");
			}

            this.InitializeComponent();
            this.InitiaizeNicoService();

			this.Padding = new Padding(0);
			this.toolStripTextBoxUrl.AllowDrop = true;
			this.toolStripTextBoxUrl.DragDrop += new DragEventHandler(toolStripTextBoxUrl_DragDrop);
			this.toolStripTextBoxUrl.DragEnter += new DragEventHandler(toolStripTextBoxUrl_DragEnter);
			this.downloadListView.DragDrop += new DragEventHandler(downloadListView_DragDrop);
			this.FormClosed += new FormClosedEventHandler(MainForm_FormClosed);


			this.tabBrowser.SetSetting(this.boonConfig_.TabBrowserSetting);

			if(File.Exists(favoriteFilePath))
			{
				this.favoriteTreeView1.FvLoadFavorite(favoriteFilePath);
			}

			this.tabSideBar.ImageList = GlobalImages.GlobalListA;
			this.tabpageSideFavorite.ImageKey = GlobalImages.IKEY_A_FAVORITE;
			this.tabpageSideHistory.ImageKey = GlobalImages.IKEY_A_PAGE;
		}

		/// <summary>
        /// NicoServiceCX^X܂B
        /// </summary>
        private void InitiaizeNicoService()
        {
            NicoService.Instance.Invoker = this;
            NicoService.Instance.MaxExecution = 2;
            NicoService.Instance.SetTaskExecution(NicoRequestType.DownloadVideo, this.boonConfig_.maxDownloadConnections);
            NicoService.Instance.SetTaskWaitTimeAll(1000);
            NicoService.Instance.SetTaskWaitTime(NicoRequestType.DownloadVideo, 3000);
            NicoService.Instance.SetRequestWaitTimeAll(250);
            NicoService.Instance.Interval = 100;
        }

        private void InitializeDownloadListView()
        {
            new VideoFileDataCollections().Deserialize(this.downloadListView);

            if (NicoService.Instance.LoggedIn)
            {
                // OCԂł́A_E[hXg̑҂̃f[^NicoServiceɍēxo^B
                foreach (ListViewItem lvi in this.downloadListView.Items)
                {
                    VideoFileData vfd = (VideoFileData)lvi.Tag;
                    // t@C݂Ȃ̂̓Xg폜
                    if (!File.Exists(vfd.videoFilePath))
                    {
                        lvi.Remove();
                        continue;
                    }

                    if (vfd.videoFileStatus == VideoFileData.DOWNLOAD_WAITING)
                    {
                        BoonDownloadManager.addReservation(vfd.videoID, lvi, false);
                    }

                }
            }
            else
            {
                // OCԂł́A_E[hXg̑҂̏ԂLZɂB
                foreach (ListViewItem lvi in this.downloadListView.Items)
                {
                    VideoFileData vfd = (VideoFileData)lvi.Tag;

                    // t@C݂Ȃ̂̓Xg폜
                    if (!File.Exists(vfd.videoFilePath))
                    {
                        lvi.Remove();
                        continue;
                    }

                    if (vfd.videoFileStatus == VideoFileData.DOWNLOAD_WAITING)
                    {
                        vfd.videoFileStatus = VideoFileData.DOWNLOAD_CANCELLED;
                        lvi.SubItems[1].Text = vfd.GetStatusMessage();
                    }
                }

            }

        }

		#endregion

		#region Group : EventHandlers

		#region +--- NicoService Event Handlers

		/// <summary>
        /// OCԂ̊mFۂ̃CxgłB
        /// </summary>
        /// <param name="sender">CxgsAsyncHttpRequestIuWFNg</param>
        /// <param name="e">Cxgp[^ێLoginStateCompletedEventArgsIuWFNg</param>
        private void loginStateCompleted(AsyncHttpRequest sender, LoginStateCompletedEventArgs e)
        {
            if (e.Cancelled)
            {
                MessageBox.Show("LZ܂B");
            }
            else if (e.Error != null)
            {
                MessageBox.Show(e.Error.Message);
            }
        }

        /// <summary>
        /// OCۂ̃CxgłB
        /// </summary>
        /// <param name="sender">CxgsAsyncHttpRequestIuWFNg</param>
        /// <param name="e">Cxgp[^ێLoginCompletedEventArgsIuWFNg</param>
        private void loginCompleted(AsyncHttpRequest sender, LoginCompletedEventArgs e)
        {
            if (e.Cancelled)
            {
                MessageBox.Show("LZ܂B");
            }
            else if (e.Error != null)
            {
                MessageBox.Show(e.Error.Message);
            }
		}

		#endregion

		#region +---- MainForm Event Handlers

		/// <summary>
        /// Form[hꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
		void MainForm_Load(object sender, EventArgs e)
		{
			this.InitializeSaveFolderTreeView();
			this.restore_window_state();
			switch(this.boonConfig_.startUpStatus)
			{
				case BoonDefine.START_UP_STATUS_OPEN_HOME_URL:
					this.tabBrowser.TbOpenNewTab(this.boonConfig_.homeUrl);
					break;
				case BoonDefine.START_UP_STATUS_OPEN_LOCKED_TAB:
					this.tabBrowser.RestoreTabsOnStartup(RestoreClosedTabFlags.OnExit | RestoreClosedTabFlags.OnlyLocked);
					break;
				case BoonDefine.START_UP_STATUS_OPEN_PREVIOUS_TAB:
					this.tabBrowser.RestoreTabsOnStartup(RestoreClosedTabFlags.OnExit);
					break;
			}
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void MainForm_Shown(object sender, EventArgs e)
		{
			using(LoginForm form = new LoginForm())
			{
				form.ShowDialog(this);
			}

			if(NicoService.Instance.LoggedIn)
			{
				this.InitializeDownloadListView();
			}
		}

		/// <summary>
		/// vȌI
		/// </summary>
		/// <param name="e">Cxgp[^ێFormClosingEventArgsIuWFNg</param>
		protected override void OnFormClosing(FormClosingEventArgs e)
		{
			base.OnFormClosing(e);
			if (!e.Cancel)
			{
				this.tabBrowser.TbHostApplicationExit();
				this.boonConfig_.TabBrowserSetting = this.tabBrowser.Setting;
				this.favoriteTreeView1.FvSaveFavorite(favoriteFilePath);
				this.store_window_state();

                BoonDownloadManager.Instance.removeAllThread();
                new VideoFileDataCollections().Serialize(this.downloadListView);

			}
		}
        /// <summary>
        /// Formꂽ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێFormClosedEventArgsIuWFNg</param>
		void MainForm_FormClosed(object sender, FormClosedEventArgs e)
		{
		}

		#endregion

		#endregion

		#region Group : Methods

		/// <summary>
		/// ݂̃^uJĂURL𕶎ƂĎ擾܂B
		/// </summary>
		/// <returns>݂URL</returns>
		public string getCurrentURL()
		{
			return (this.tabBrowser.TbUrl);
		}
        /// <summary>
        /// Form̏IłB
        /// </summary>
        private void endForm()
        {
            // ݊JĂ^ȕԂۑ鏈
            // EChȄԂۑ鏈
            this.Close();
		}

		#endregion


		#region ToolStrip֘A

		#region +---- ToolStrip Event Handlers

		/// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void toolStripButton1_back_Click(object sender, EventArgs e)
		{
			this.tabBrowser.TbGoBack();
		}
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void toolStripButton01_back_MouseDown(object sender, MouseEventArgs e)
		{
			if(this.tabBrowser.TbSelectedIsBrowser)
			{
				if(e.Button == MouseButtons.Right)
				{
					this.tabBrowser.TbShowNavigateHistory(Cursor.Position, true);
				}
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void toolStripButton2_forward_Click(object sender, EventArgs e)
		{
			this.tabBrowser.TbGoForward();
		}
		private void toolStripButton02_forward_MouseDown(object sender, MouseEventArgs e)
		{
			if(this.tabBrowser.TbSelectedIsBrowser)
			{
				if(e.Button == MouseButtons.Right)
				{
					this.tabBrowser.TbShowNavigateHistory(Cursor.Position, false);
				}
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void toolStripButton3_stop_Click(object sender, EventArgs e)
		{
			this.tabBrowser.TbStop();
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void toolStripButton4_refresh_Click(object sender, EventArgs e)
		{
			this.tabBrowser.TbRefresh();
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton5_home_Click(object sender, EventArgs e)
        {
            this.tabBrowser.TbNavigate(boonConfig_.homeUrl);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton6_favorite_Click(object sender, EventArgs e)
        {
            if (this.toolStripButton6_favorite.Checked)
            {
				if(this.toolStripButton7_history.Checked) { this.toolStripButton7_history.Checked = false; }
				this.tabSideBar.SelectedIndex = 0;
				this.appearSidePanel(true);
            }
            else
            {
                this.appearSidePanel(false);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton7_history_Click(object sender, EventArgs e)
        {
            if (this.toolStripButton7_history.Checked)
            {
				if(this.toolStripButton6_favorite.Checked) { this.toolStripButton6_favorite.Checked = false; }
                this.appearSidePanel(true);
				this.tabSideBar.SelectedIndex = 1;
            }
            else
            {
				this.appearSidePanel(false);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripButton8_showDownloadList_Click(object sender, EventArgs e)
        {
			this.appearUnderPanel(this.toolStripButton8_showDownloadList.Checked);
        }

		private void toolStripButton9_download_Click(object sender, EventArgs e)
		{
			string url = this.tabBrowser.TbUrl;
			string title = this.tabBrowser.TbTitle;
			this.toolStripButton9_download.Enabled = false;

			if(!(String.IsNullOrEmpty(url) || String.IsNullOrEmpty(title)))
			{
				string queryUrl = this.getBoonLinkString(url, title);
				if(!String.IsNullOrEmpty(queryUrl))
				{
					this.setDownloadReservation(queryUrl);
				}
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void toolStripButton10_search_Click(object sender, EventArgs e)
		{
			if(this.toolStripComboBoxSearch.Text != "")
			{
				string stxt = this.toolStripComboBoxSearch.Text;
				
				for(int i = 0; i < this.toolStripComboBoxSearch.Items.Count; i++)
				{
					if(stxt.Equals((string)this.toolStripComboBoxSearch.Items[i]))
					{
						this.toolStripComboBoxSearch.Items.RemoveAt(i);
						break;
					}
				}
				while(this.toolStripComboBoxSearch.Items.Count >= this.toolStripComboBoxSearch.MaxDropDownItems)
				{
					this.toolStripComboBoxSearch.Items.RemoveAt(this.toolStripComboBoxSearch.Items.Count - 1);
				}
				this.toolStripComboBoxSearch.Items.Insert(0, stxt);

				this.navigateToSearchPage(stxt);
			}
		}
        
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
		private void toolStripButton11_go_Click(object sender, EventArgs e)
		{
			this.navigateByUrlTextbox();
		}

		private void toolStripTextBoxUrl_KeyDown(object sender, KeyEventArgs e)
		{
			if(e.KeyCode == System.Windows.Forms.Keys.Enter)
			{
				e.Handled = true;
				this.navigateByUrlTextbox();
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripComboBox1_Click(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void toolStripComboBox1_KeyDown(object sender, KeyEventArgs e)
        {
			if(e.KeyCode == System.Windows.Forms.Keys.Enter)
			{
				e.Handled = true;
				if(this.toolStripComboBoxSearch.Text != "")
				{
					this.navigateToSearchPage(this.toolStripComboBoxSearch.Text);
				}
			}
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێDragEventArgsIuWFNg</param>
		void toolStripTextBoxUrl_DragEnter(object sender, DragEventArgs e)
		{
		}

        /// <summary>
        /// URLeLXg{bNXD&Dꂽۂ̃CxgłB
        /// </summary>
        /// <param name="sender">Cxg𔭍sIuWFNg</param>
        /// <param name="e">Cxgp[^ێDragEventArgsIuWFNg</param>
		void toolStripTextBoxUrl_DragDrop(object sender, DragEventArgs e)
		{
			System.Diagnostics.Debug.WriteLine(e.Data.GetData(typeof(string)));
            // ȂÃ݂^uŉʑJڂs
		}

		#endregion


		/// <summary>
        /// 
        /// </summary>
        /// <param name="searchText"></param>
        private void navigateToSearchPage(string searchText)
        {
            if ((searchText == null) || (searchText.Equals(String.Empty) )) return;
            this.addURLToComboBox(this.toolStripComboBoxSearch, searchText);
			searchText = Uri.EscapeDataString(searchText);
            this.tabBrowser.TbNavigate(BoonCommon.Url_NicoSearch + searchText);
		}

		/// <summary>
		/// 
		/// </summary>
		private void navigateByUrlTextbox()
		{
			if(this.toolStripTextBoxUrl.Text != String.Empty)
			{
				this.tabBrowser.TbNavigate(this.toolStripTextBoxUrl.Text);
			}
		}

        /// <summary>
        /// 
        /// </summary>
        /// <param name="comboBox"></param>
        /// <param name="addText"></param>
        private void addURLToComboBox(ToolStripComboBox comboBox, string addText)
        {
            if (comboBox.Items.Contains(addText)) comboBox.Items.RemoveAt(comboBox.Items.IndexOf(addText));

            comboBox.Items.Insert(0, addText);

            if (comboBox.Items.Count > comboBox.MaxDropDownItems)
            {
                comboBox.Items.RemoveAt(comboBox.Items.Count - 1);
            }
        }

        #endregion


		#region +++ MainForm ԕۑp (Class x1, Field x2, Method x2) ++++

		MF_Settings _mfState;
		string _mfStatePath = Path.Combine(Application.StartupPath, "mfstate.xml");

		private void store_window_state()
		{
			if(this._mfState == null) { this._mfState = new MF_Settings(); }

			this._mfState.CHK_Silent = this.mainMenu403_HideSuriptErrorDialogue.Checked;
			this._mfState.CHK_TopMost = this.mainMenu402_ShowAtMostTop.Checked;

			this._mfState.SPL_ClpsMain = !UnderPanelShown;
			if(!this.SidePanelShown)
			{
				this._mfState.SIDE_SelectedTab = MF_Settings.C_SIDE_NONE;
			}
			else
			{
				this._mfState.SIDE_SelectedTab = this.tabSideBar.SelectedIndex;
			}

			this._mfState.SPL_UnderLeft = this.saveFolderTreeView.Width;
			this._mfState.SPL_MainSide = this.pnlSide.Width;
			this._mfState.SPL_MainUnder = this.pnlCenter.Height;

			this._mfState.Size = this.Size;
			this._mfState.Location = this.Location;

			MF_Settings.Serialize(this._mfState, this._mfStatePath);
		}
		private void restore_window_state()
		{
			if(File.Exists(this._mfStatePath))
			{
				this._mfState = MF_Settings.Deserialize(this._mfStatePath);

				Screen screen = Screen.PrimaryScreen;
				Rectangle rectScr = screen.WorkingArea;
				Rectangle rectForm = new Rectangle(this._mfState.Location, this._mfState.Size);

				if(rectForm.Bottom > rectScr.Bottom) { rectForm.Offset(0, rectScr.Bottom - rectForm.Bottom); }
				if(rectForm.Right > rectScr.Right) { rectForm.Offset(rectScr.Right - rectForm.Right, 0); }
				if(rectForm.Top < rectScr.Top) { rectForm.Offset(0, rectScr.Top - rectForm.Top); }
				if(rectForm.Left < rectScr.Left) { rectForm.Offset(rectScr.Left - rectForm.Left, 0); }

				if(rectForm.Bottom > rectScr.Bottom) { rectForm.Inflate(0, rectScr.Bottom - rectForm.Bottom); }
				if(rectForm.Right > rectScr.Right) { rectForm.Inflate(rectScr.Right - rectForm.Right, 0); }

				if(!rectScr.Contains(rectForm)) { MessageBox.Show("SA~XĂ("); }

				this.Size = rectForm.Size;
				this.Location = rectForm.Location;

				this.pnlCenter.Height = this._mfState.SPL_MainUnder;
				this.pnlSide.Width = this._mfState.SPL_MainSide;
				this.saveFolderTreeView.Width = this._mfState.SPL_UnderLeft;
				this.toolStripButton8_showDownloadList.Checked = !this._mfState.SPL_ClpsMain;
				this.UnderPanelShown = !this._mfState.SPL_ClpsMain;

				switch(this._mfState.SIDE_SelectedTab)
				{
					case MF_Settings.C_SIDE_NONE:
						this.toolStripButton6_favorite.Checked = false;
						this.toolStripButton7_history.Checked = false;
						this.SidePanelShown = false;
						break;
					case MF_Settings.C_SIDE_FAVORITE:
						this.tabSideBar.SelectedIndex = MF_Settings.C_SIDE_FAVORITE;
						this.toolStripButton6_favorite.Checked = true;
						this.toolStripButton7_history.Checked = false;
						this.SidePanelShown = true;
						break;
					case MF_Settings.C_SIDE_HISTORY:
						this.tabSideBar.SelectedIndex = MF_Settings.C_SIDE_HISTORY;
						this.toolStripButton6_favorite.Checked = false;
						this.toolStripButton7_history.Checked = true;
						this.SidePanelShown = true;
						break;
				}

				this.mainMenu403_HideSuriptErrorDialogue.Checked = this._mfState.CHK_Silent;
				this.mainMenu402_ShowAtMostTop.Checked = this._mfState.CHK_TopMost;

				this.tabBrowser.TbSilentMode = this._mfState.CHK_Silent;
				this.TopMost = this._mfState.CHK_TopMost;
			}
			else
			{
				this._mfState = new MF_Settings();
			}
		}

		[Serializable]
		public class MF_Settings
		{
			public const int C_SIDE_NONE = -1;
			public const int C_SIDE_FAVORITE = 0;
			public const int C_SIDE_HISTORY = 1;

			public Size Size;
			public Point Location;
			public int SIDE_SelectedTab;
			public int SPL_MainSide;
			public int SPL_MainUnder;
			public int SPL_UnderLeft;
			public bool SPL_ClpsMain;

			public bool CHK_Silent;
			public bool CHK_TopMost;

			public MF_Settings()
			{
				this.Size = new Size(700, 600);
				this.Location = new Point(200, 100);
				this.SIDE_SelectedTab = C_SIDE_NONE;
				this.SPL_MainUnder = 400;
				this.SPL_MainSide = 150;
				this.SPL_UnderLeft = 150;
				this.SPL_ClpsMain = true;
				this.CHK_Silent = false;
				this.CHK_TopMost = false;
			}

			public static MF_Settings Deserialize(string path)
			{
				if(!File.Exists(path)) { throw new FileNotFoundException("mf_setting܂"); }

				XmlSerializer ser = new XmlSerializer(typeof(MF_Settings));
				MF_Settings re = null;
				try
				{
					using(StreamReader sread = new StreamReader(path))
					using(XmlTextReader reader = new XmlTextReader(sread))
					{
						if(reader != null)
						{
							re = ser.Deserialize(reader) as MF_Settings;
						}
					}
				}
				finally
				{
					if(re == null) { re = new MF_Settings(); }
				}
				return re;
			}
			public static bool Serialize(MF_Settings obj, string path)
			{
				if(!Path.IsPathRooted(path)) { return false; }

				XmlSerializer ser = new XmlSerializer(typeof(MF_Settings));
				try
				{
					using(StreamWriter sw = new StreamWriter(path))
					using(XmlTextWriter writer = new XmlTextWriter(sw))
					{
						if(writer != null)
						{
							ser.Serialize(writer, obj);
						}
					}
					return true;
				}
				catch { return false; }
			}
		}

		#endregion

	}


}
