using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Text.RegularExpressions;

namespace Boon.Forms.Dialog
{
	public partial class SearchFileDialog : Form
	{
		public SearchFileDialog()
		{
			InitializeComponent();
		}

		/// <summary>
		/// t@C_CAO\܂B
		/// </summary>
		/// <param name="owner">[_EBhẼI[i[</param>
		/// <param name="combolist">R{{bNXɒǉ郊Xg</param>
		/// <param name="directory">̃[gtH_BiύX邱Ƃ̂ŁAݒf[^̎QƂ̂܂ܓnȂ悤Ӂj</param>
		/// <param name="pattern">p^[ioutj</param>
		/// <param name="sub">TutH_邩ǂioutj</param>
		/// <returns>_CAOɑ΂郆[U[̔</returns>
		public DialogResult ShowSearchDialog(IWin32Window owner, object[] combolist, ref DirectoryInfo directory, out string pattern,out bool sub)
		{
			this.treeDirectory.Nodes.Clear();
			this.cmbSearchPattern.Items.Clear();
			if(combolist != null)
				this.cmbSearchPattern.Items.AddRange(combolist);

			TreeNode rootnode = new TreeNode("ۑtH_");
			rootnode.Tag = directory;
			rootnode.ToolTipText = directory.FullName;
			this.treeDirectory.Nodes.Add(rootnode);
			this.treeDirectory.SelectedNode = rootnode;
			this.create_child(rootnode, directory.GetDirectories());

			DialogResult result = this.ShowDialog(owner);

			if(result == DialogResult.OK && this.treeDirectory.SelectedNode != null)
			{
				directory = this.treeDirectory.SelectedNode.Tag as DirectoryInfo;
			}
			pattern = this.cmbSearchPattern.Text;
			this.treeDirectory.Nodes.Clear();
			sub = this.chkIncludeSubDir.Checked;
			return result;
		}

		private void create_child(TreeNode parent, DirectoryInfo[] children)
		{
			for(int i = 0; i < children.Length; ++i)
			{
				if((children[i].Attributes & FileAttributes.Hidden) != FileAttributes.Hidden)
				{
					TreeNode child = new TreeNode(children[i].Name);
					child.Tag = children[i];
					child.ToolTipText = children[i].FullName;
					parent.Nodes.Add(child);
				}
			}
		}

		private void btnOK_Click(object sender, EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
		}
		private void btnCancel_Click(object sender, EventArgs e)
		{
		}

		private void treeDirectory_BeforeExpand(object sender, TreeViewCancelEventArgs e)
		{
			foreach(TreeNode tn in e.Node.Nodes)
			{
				DirectoryInfo dir = tn.Tag as DirectoryInfo;
				if(dir != null)
				{
					this.create_child(tn, dir.GetDirectories());
				}
			}
		}
	}
}