/**
 * @file main.c
 * @author Copyright(C) 2012 Shinichiro Nakamura
 * @brief BlueTank ACB-BF592 Application Sample Codes.
 */

/*
 * ===============================================================
 *  BlueTank
 * ===============================================================
 * Copyright (c) 2012 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#include <stdlib.h>
#include "uzura.h"
#include "effect.h"
#include "system.h"
#include "ntl.h"
#include "lcd.h"
#include "ntlext.h"

typedef struct {
    UZURA uzura;
} work_t;

static void s_effect_through(
        UZURA *p,
        const int32_t *src, int32_t *des, int32_t count)
{
    int i;

    NTL_EVENT_START(NTLEXT_TRACK_AUDIO, NTLEXT_EVENT_AUDIO_LEVINIT);
    UZURA_LEVEL_INPUT(p).left = 0;
    UZURA_LEVEL_INPUT(p).right = 0;
    UZURA_LEVEL_OUTPUT(p).left = 0;
    UZURA_LEVEL_OUTPUT(p).right = 0;
    NTL_EVENT_END(NTLEXT_TRACK_AUDIO, NTLEXT_EVENT_AUDIO_LEVINIT);

    for (i = 0; i < count; i+=2) {

        NTL_EVENT_START(NTLEXT_TRACK_AUDIO, NTLEXT_EVENT_AUDIO_DATCOPY);
        *(des + i + 0) = *(src + i + 0);
        *(des + i + 1) = *(src + i + 1);
        NTL_EVENT_END(NTLEXT_TRACK_AUDIO, NTLEXT_EVENT_AUDIO_DATCOPY);

        NTL_EVENT_START(NTLEXT_TRACK_AUDIO, NTLEXT_EVENT_AUDIO_LEVCALC);
        UZURA_LEVEL_INPUT(p).left += abs(*(src + i + 0)) >> 1;
        UZURA_LEVEL_INPUT(p).right += abs(*(src + i + 1)) >> 1;
        UZURA_LEVEL_OUTPUT(p).left += abs(*(des + i + 0)) >> 1;
        UZURA_LEVEL_OUTPUT(p).right += abs(*(des + i + 1)) >> 1;
        NTL_EVENT_END(NTLEXT_TRACK_AUDIO, NTLEXT_EVENT_AUDIO_LEVCALC);
    }
}

static void s_system_default(UZURA *p)
{
    NTL_EVENT_START(NTLEXT_TRACK_DISPLAY, NTLEXT_EVENT_DISPLAY_GOTO);
    lcd_goto(0, 0);
    NTL_EVENT_END(NTLEXT_TRACK_DISPLAY, NTLEXT_EVENT_DISPLAY_GOTO);

    NTL_EVENT_START(NTLEXT_TRACK_DISPLAY, NTLEXT_EVENT_DISPLAY_PUTC);
    lcd_putc(0x08 + (UZURA_LEVEL_INPUT(p).left   >> 29));
    lcd_putc(0x08 + (UZURA_LEVEL_INPUT(p).right  >> 29));
    lcd_putc(0x08 + (UZURA_LEVEL_OUTPUT(p).left  >> 29));
    lcd_putc(0x08 + (UZURA_LEVEL_OUTPUT(p).right >> 29));
    lcd_putc(0x08 + (UZURA_LEVEL_INPUT(p).left   >> 29));
    lcd_putc(0x08 + (UZURA_LEVEL_INPUT(p).right  >> 29));
    lcd_putc(0x08 + (UZURA_LEVEL_OUTPUT(p).left  >> 29));
    lcd_putc(0x08 + (UZURA_LEVEL_OUTPUT(p).right >> 29));
    NTL_EVENT_END(NTLEXT_TRACK_DISPLAY, NTLEXT_EVENT_DISPLAY_PUTC);
}

int main(void)
{
    work_t w;

    ntl_init();
    effect_param_init();
    uzura_init(&w.uzura, &w);
    uzura_set_effect(&w.uzura, s_effect_through);
    uzura_set_system(&w.uzura, s_system_default);
    uzura_execute(&w.uzura);

    return 0;
}

