/**
 * @file main.c
 * @author Copyright(C) 2012 Shinichiro Nakamura
 * @brief BlueTank ACB-BF592 Application Sample Codes.
 */

/*
 * ===============================================================
 *  BlueTank
 * ===============================================================
 * Copyright (c) 2012 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#include <stddef.h>
#include "uzura.h"
#include "lcd.h"
#include "led.h"
#include "effect.h"
#include "rotenc.h"

#define LOTTHR  (5)     /**< Lotate Threshold. */
#define SCRSPD  (16)    /**< Scroll Speed. */

typedef struct {
    UZURA uzura;
    uint8_t effect;
    int8_t locate_target;
    int8_t locate_current;
} work_t;

static void rotenc_callback(RotencAction action, void *extobj)
{
    static int lotdiv = 0;

    work_t *w = (work_t *)extobj;
    if (RotencActionPush == action) {
        w->effect = !w->effect;
        if (w->effect) {
            uzura_set_effect(&(w->uzura), effect_karaoke);
            led_write(LedTargetR, 0);
            led_write(LedTargetG, 1);

        } else {
            uzura_set_effect(&(w->uzura), effect_through);
            led_write(LedTargetR, 1);
            led_write(LedTargetG, 1);
        }
    }
    if (RotencActionLeft == action) {
        if (lotdiv < -LOTTHR) {
            w->locate_target-=8;
            if (w->locate_target < 0) {
                w->locate_target = 0;
            }
            lotdiv = 0;
        } else {
            if (0 < lotdiv) {
                lotdiv = 0;
            }
            lotdiv--;
        }
    }
    if (RotencActionRight == action) {
        if (LOTTHR < lotdiv) {
            w->locate_target+=8;
            if (32 < w->locate_target) {
                w->locate_target = 32;
            }
            lotdiv = 0;
        } else {
            if (lotdiv < 0) {
                lotdiv = 0;
            }
            lotdiv++;
        }
    }
}

static void system_dynamic_menu(UZURA *p)
{
    work_t *w = (work_t *)UZURA_USER_DATA(p);

    lcd_goto(0, 0);
    lcd_putc(0x08 + (UZURA_LEVEL_INPUT(p).left   >> 29));
    lcd_putc(0x08 + (UZURA_LEVEL_INPUT(p).right  >> 29));
    lcd_putc(0x08 + (UZURA_LEVEL_OUTPUT(p).left  >> 29));
    lcd_putc(0x08 + (UZURA_LEVEL_OUTPUT(p).right >> 29));
    lcd_putc(0x08 + (UZURA_LEVEL_INPUT(p).left   >> 29));
    lcd_putc(0x08 + (UZURA_LEVEL_INPUT(p).right  >> 29));
    lcd_putc(0x08 + (UZURA_LEVEL_OUTPUT(p).left  >> 29));
    lcd_putc(0x08 + (UZURA_LEVEL_OUTPUT(p).right >> 29));

    static uint8_t divcnt = 0;
    if (((divcnt++) % SCRSPD) == 0) {
        if (w->locate_current < w->locate_target) {
            lcd_display_shift(Left);
            w->locate_current++;
        }
        if (w->locate_target < w->locate_current) {
            lcd_display_shift(Right);
            w->locate_current--;
        }
    }
}

int main(void)
{
    work_t w;

    w.effect = 0;
    w.locate_target = 0;
    w.locate_current = 0;

    effect_param_init();
    uzura_init(&w.uzura, &w);
    uzura_set_effect(&w.uzura, effect_through);
    uzura_set_system(&w.uzura, system_dynamic_menu);
    led_write(LedTargetR, 1);
    led_write(LedTargetG, 1);
    rotenc_init(rotenc_callback, &w);
    uzura_execute(&w.uzura);

    return 0;
}

