/**
 * @file led.c
 * @author Copyright(C) 2012 Shinichiro Nakamura
 * @brief BlueTank ACB-BF592 Application Sample Codes.
 */

/*
 * ===============================================================
 *  BlueTank
 * ===============================================================
 * Copyright (c) 2012 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#include <cdefBF592-A.h>
#include "led.h"

#define LED_BIT_R   PG14
#define LED_BIT_G   PG15

void led_init(void)
{
    *pPORTGIO_CLEAR = LED_BIT_R;
    *pPORTGIO_CLEAR = LED_BIT_G;

    *pPORTGIO_DIR |= LED_BIT_R;
    *pPORTGIO_DIR |= LED_BIT_G;
}

void led_write(LedTarget target, int on)
{
    switch (target) {
        case LedTargetR:
            if (on) {
                *pPORTGIO_SET   = LED_BIT_R;
            } else {
                *pPORTGIO_CLEAR = LED_BIT_R;
            }
            break;
        case LedTargetG:
            if (on) {
                *pPORTGIO_SET   = LED_BIT_G;
            } else {
                *pPORTGIO_CLEAR = LED_BIT_G;
            }
            break;
    }
}

