/**
 * @file lcd.h
 * @author Copyright(C) 2012 Shinichiro Nakamura
 * @brief BlueTank ACB-BF592 Application Sample Codes.
 */

/*
 * ===============================================================
 *  BlueTank
 * ===============================================================
 * Copyright (c) 2012 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * ===============================================================
 */

#ifndef _LCD_H_
#define _LCD_H_

#include <stdbool.h>
#include <stdint.h>

typedef enum {
    Left,
    Right
} Direction;

typedef enum {
    UserFont1,
    UserFont2,
    UserFont3,
    UserFont4,
    UserFont5,
    UserFont6,
    UserFont7,
    UserFont8
} UserFont;

#define LCD_FONT_WIDTH  (5)
#define LCD_FONT_HEIGHT (8)
#define LCD_FONT_CHARS  (8)

typedef struct {
    unsigned char data[LCD_FONT_HEIGHT];
} Font;

typedef struct {
    Font fontlist[LCD_FONT_CHARS];
} FontSet;

void lcd_init(void);
void lcd_clear(void);
void lcd_cursor_at_home(void);
void lcd_entry_mode_set(bool increment, bool shifted);
void lcd_display(bool display, bool cursor, bool blink);
void lcd_cursor_shift(Direction dir);
void lcd_display_shift(Direction dir);
void lcd_goto(uint8_t x, uint8_t y);
void lcd_putc(char c);
void lcd_puts(char *str);
void lcd_font_init(FontSet *fs);
void lcd_font_set_pixel(
        FontSet *fs, UserFont index,
        const int x, const int y, const int on);
void lcd_font_draw_line(
        FontSet *fs, UserFont index,
        int x1, int y1,
        int x2, int y2,
        int on);
void lcd_font_setup_single(FontSet *fs, UserFont index);
void lcd_font_setup_all(FontSet *fs);

#endif

