/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.generator;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Yasuo Nakanishi
 */
public class PackageTransformer {
    private List _originalPackages = new ArrayList();
    private List _userPackages = new ArrayList();
    private List _originalPathList = new ArrayList();
    private List _userPathList = new ArrayList();

    public PackageTransformer() {
    }
    
    public void addPackagePair(String original, String user) {
        int index = getListPosition(original);
        
        _originalPackages.add(index, original);
        _userPackages.add(index, user);
        _originalPathList.add(index, original.replaceAll("\\.", "/"));
        _userPathList.add(index, user.replaceAll("\\.", "/"));
    }
    
    private int getListPosition(String original) {
        int result = _originalPathList.size();
        String path = "";

        for(int i = _originalPathList.size() - 1; i >= 0; i--) {
            path = (String) _originalPathList.get(i);
            if(path.length() < original.length()) {
                result = i;
                break;
            }
        }
        return result;
    }
    
    public String getTargetPath(String outputPath, String sourcePath) {
        String result = sourcePath;
        
        String original = "";
        String user = "";
        for(int i = 0; i < _originalPathList.size(); i++) {
            original = (String) _originalPathList.get(i);
            user = (String) _userPathList.get(i);
            if(sourcePath.indexOf(original) != -1) {
                result =  sourcePath.replaceAll(original, user);
                break;
            }
        }
        return outputPath + "/" + result;
    }
    
    public String replacePackage(String line) {
        String result = line;
        
        String original = "";
        String user = "";
        for(int i = 0; i < _originalPathList.size(); i++) {
            original = (String) _originalPackages.get(i);
            user = (String) _userPackages.get(i);
            result = result.replaceAll(original, user);
        }
        return result;
    }
}
