/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.generator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import blanco.core.datastruct.DataStructClass;
import blanco.ig.expander.ClassExpander;
import blanco.ig.io.SourceWriter;
import blanco.ig.service.ObjectClass;
import blanco.ig.service.ServiceClass;
import blanco.ig.tool.ConsolePrinter;

/**
 * @author Yasuo Nakanishi
 */
public final class ImplementGenerator extends AbstructGenerator {
	private String _pathSeparator = "/";
    private List _dataStructClassList = new ArrayList();
    private List _mainClassList = new ArrayList();
	private List _testClassList = new ArrayList();
	private GeneratorSetting _setting = null;
	private ConsolePrinter _printer = ConsolePrinter.get(); 
    private SourceWriter _writer = null;

	public ImplementGenerator(ServiceClass serviceClass, GeneratorSetting setting) {
        super(serviceClass);
		_setting = setting;
	}

    public void generateDataStruct() throws IOException{
        String outputDirectory = _setting.getMainOutputDirectory();
        _printer.printInfo("DataStruct̐Jn܂Bo̓fBNg:" + outputDirectory);

        for(int i = 0; i < _dataStructClassList.size(); i++) {
            generateClass(outputDirectory, (ClassExpander) _dataStructClassList.get(i));
        }
    }

    public void generateMain() throws IOException{
        String outputDirectory = _setting.getMainOutputDirectory();
        _printer.printInfo("CNX̐Jn܂Bo̓fBNg:" + outputDirectory);

        for(int i = 0; i < _mainClassList.size(); i++) {
            generateClass(outputDirectory, (ClassExpander) _mainClassList.get(i));
        }
	}

    public void generateTest() throws IOException{
        String outputDirectory = _setting.getTestOutputDirectory();
        _printer.printInfo("eXgNX̐Jn܂Bo̓fBNg:" + outputDirectory);

        for(int i = 0; i < _testClassList.size(); i++) {
            generateClass(outputDirectory, (ClassExpander) _testClassList.get(i));
        }
    }

	private void generateClass(String outputDirectory, ClassExpander classExpander) throws IOException{
	    assert !classExpander.getName().equals("");
	    
		String path = getOutputPath(outputDirectory, classExpander);
        _writer = new SourceWriter(_setting.getSoruceEncoding());
        _writer.write(path, classExpander.expand());
        
        String name = classExpander.getType().getFullName();
        if(_writer.isCreated()) {
            _printer.printInfo("NX:" + name);
        } else if(_writer.isUpdated()) {
            _printer.printInfo("XVNX:" + name);
        }
        classExpander.clear();
	}
    
	public String getOutputFileName(ClassExpander classSource){
		return classSource.getName() + ".java";
	}

	public String getOutputPath(String outputDirectory, ClassExpander classSource){
		StringBuffer sb = new StringBuffer();
		sb.append(getOutputDirectory(outputDirectory, classSource));
		sb.append(_pathSeparator);
		sb.append(getOutputFileName(classSource));
		return new String(sb);
	}

	public String getOutputDirectory(String outputDirectory, ClassExpander classSource){
		String path = getNameSpaceToPath(classSource.getNameSpace());
		return outputDirectory + _pathSeparator + path;
	}

	private String getNameSpaceToPath(String nameSpace){
		return nameSpace.replaceAll("\\.", _pathSeparator);
	}

    public void addMain(ClassExpander expander) {
        if(expander instanceof DataStructClass) {
            DataStructClass dataStruct = (DataStructClass) expander; 
            addDataStruct(dataStruct);
        } else { 
            _mainClassList.add(expander);
        }
    }

    public void addDataStruct(ObjectClass objectClass, DataStructClass expander) {
        _dataStructClassList.add(expander);
        MasterGenerator.get().addDataStruct(objectClass, expander);
    }

    public void addDataStruct(DataStructClass expander) {
        String name = expander.getName();
        ObjectClass objectClas = new ObjectClass(getServiceClass(), "DataStruct", name);
        addDataStruct(objectClas, expander);
    }

    public void addTest(ClassExpander expander) {
        _testClassList.add(expander);
    }

    public void generateRuntime() throws IOException {
    }
}
