/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.implementor;

import java.util.ArrayList;
import java.util.List;

import blanco.ig.expander.Type;
import blanco.ig.expander.Value;

/**
 * @author Yasuo
 */
public class Statement {
    private List _usingTypeList = new ArrayList();
    private String _statement = "";
    private boolean _nagation = false;
    private String _joinOperator = null;
    private Statement _joined = null;
    private Type _type = null;
    private Statement _previousStatement = null;
    private Statement _nextStatement = null;

    public Statement() {
    }

    public Statement(String statement) {
        _statement = statement;
    }

    public Statement(Value value) {
        _statement = value.getName();
    }
    
    public Statement(Type type, String literal) {
        _type = type;
        _statement = literal; 
     }

    public Statement(Class type, String literal) {
        _type = new Type(type);
        _statement = literal; 
     }

    protected void setStatement(String statement) {
        _statement = statement;
    }

    public void setNagation(boolean nagation) {
        _nagation = nagation;
    }
    
    protected void addSubStatement(Statement statement) {
        _nextStatement = statement;
        statement.setPrevious(this);
    }
    
    protected String getStatementString() {
        return _statement;
    }
    
    public void join(String operator, Statement right) {
        assert !operator.equals("");
        assert right != null;
        
        _joinOperator = operator;
        _joined = right;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (_nagation) {
            sb.append("!");
        }
        if(_type != null && _type.isArray()) {
            sb.append("new ");
            sb.append(_type.getName());
            sb.append("{");
            sb.append(getStatementString());
            sb.append("}");
        } else {
            sb.append(getStatementString());
        }
        if(isJoined()) {
            sb.append(getJoinedString());
        }
        return sb.toString();
    }
    
    private boolean isJoined() {
        return _joined != null;
    }
    
    private String getJoinedString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" ");
        sb.append(_joinOperator);
        sb.append(" ");
        sb.append(_joined.toString());
        return sb.toString();
    }
    
    public boolean isTopStatement() {
        return _previousStatement == null;
    }
    
    public void setPrevious(Statement statement) {
        if(isTopStatement()) {
            _previousStatement = statement;
            statement.addUsingTypeList(_usingTypeList);
            _usingTypeList = null;
        }
    }
    
    public int getUsingTypeCount(){
        return getUsingTypeList().size();
    }
    
    public void addUsingType(Type type){
        getUsingTypeList().add(type);
    }

    public void addUsingTypeList(List typeList){
        assert typeList != null;
        getUsingTypeList().addAll(typeList);
    }

    public Type getUsingType(int index){
        return (Type) _usingTypeList.get(index);
    }

    public List getUsingTypeList() {
        List result = null;
        if(isTopStatement()) {
            result = _usingTypeList;
        } else {
            result = _previousStatement.getUsingTypeList(); 
        }
        assert result != null;
        return result;
    }
}
