/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.implementor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.ig.expander.Type;

public class Array extends Statement {
   
    private Type _type = null;
    private List _items = new ArrayList();

    public Array(Type type) {
        _type = type;
        addUsingType(type);
    }
    
    public Array(Class type) {
        this(new Type(type));
    }

    public void addArgument(Statement statement) {
        _items.add(statement);
        addSubStatement(statement);
    }

    public String getStatementString() {
        StringBuffer sb = new StringBuffer();
        
        sb.append("new ");
        sb.append(_type.getName());
        sb.append("[]");
        sb.append("{");

        Iterator i = _items.iterator();
        Statement s = null;
        if(i.hasNext()) {
            s = (Statement) i.next();
            sb.append(s.toString());
        }
        while(i.hasNext()) {
            sb.append(", ");
            s = (Statement) i.next();
            sb.append(s.toString());
        }
        sb.append("}");
        return sb.toString();
    }
}
