/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.ig.expander.field;

import java.util.ArrayList;
import java.util.List;

import blanco.ig.expander.Expander;
import blanco.ig.expander.NameAdjuster;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.javadoc.MethodJavaDoc;

/**
 * @author Yasuo Nakanishi
 */
public abstract class FieldExpander implements Expander {
	private Value _value = null;
    private Value _fieldValue = null;
	private boolean _isStatic = false;
	private boolean _isFinal ;
	private Scope _scope = Scope.PRIVATE;
	private MethodJavaDoc _javaDoc = new MethodJavaDoc(); 
    private NameAdjuster _adjuster = new NameAdjuster();
    private String _defaultValue = "";
    private List _usingType = new ArrayList();

    public FieldExpander(Class type, String name){
        this(new Value(type, name));
    }

    public FieldExpander(Type type, String name){
        this(new Value(type, name));
    }

	public FieldExpander(Value value){
		_value = value;
        _fieldValue = new Value(_value.getType(), _adjuster.toFieldName(_value.getName()));
        _usingType.add(_value.getType());
	}
    
    public Value getFieldValue() {
        return _fieldValue;
    }
	
	public MethodJavaDoc getJavaDoc(){
		return _javaDoc;
	}

	protected void setStatic(boolean isStatic){
		_isStatic = isStatic;
	}

	protected void setFinal(boolean isFinal){
		_isFinal = isFinal;
	}

    public void setLiteralValue(String literal){
        StringBuffer sb = new StringBuffer(literal);
        if(_value.getType().equals(String.class)) {
            sb.insert(0, "\"");
            sb.append("\"");
        }
        _defaultValue = sb.toString();
    }

    public void setDefaultValue(Class constructType){
        _defaultValue = "new" + constructType.getName() + "()";
        _usingType.add(new Type(constructType));
    }

    public void setDefaultStatement(Statement statement){
        _defaultValue = statement.toString();
        _usingType.addAll(statement.getUsingTypeList());
    }

	public Value getTypeValue(){
		return _value;
	}

	public String getFieldDeclaration(){
		StringBuffer sb = new StringBuffer();

		sb.append(_scope.get());
		sb.append(" ");
		if(_isStatic){
			sb.append("static ");
		}
		if(_isFinal){
			sb.append("final ");
		}
		sb.append(_value.getType().getName());
		sb.append(" ");
		sb.append(_adjuster.toFieldName(_value.getName()));

		if(!_defaultValue.equals("")){
            sb.append(" = ");
            sb.append(_defaultValue);
		}
		sb.append(";");
		return new String(sb);
	}

	public List expand(){
		List result = new ArrayList();
		if(!_javaDoc.isEmpty()){
			List list = _javaDoc.expand();
			for(int i = 0; i < list.size(); i++){
				result.add("\t" + list.get(i));
			}
		}
		result.add("\t" + getFieldDeclaration());
		return result;
	}
    
    public List getUsingTypeList() {
        return _usingType;
    }

	public Scope getScope() {
		return _scope;
	}

	public void setScope(Scope scope) {
		_scope = scope;
	}
}
