/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct.test;

import blanco.core.datastruct.DataStructDefinition;
import blanco.core.datastruct.DataStructField;
import blanco.core.datastruct.ReadAccessor;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.implementor.StringLiteral;
import blanco.ig.expander.method.StaticMethod;

/**
 * @author Yasuo Nakanishi
 */
public class ToStringMethod extends StaticMethod {
    private Implementor _implementor = null;

    private DataStructDefinition _definition = null;
	
	public ToStringMethod(DataStructDefinition definition ) {
		super("toString");
		_definition = definition;
		_implementor = new Implementor(getData());
	}
	
    public void setupSignature() {
        setReturnType(new Type(String.class));
        
        addArgument(new Value(new Type(_definition.getName()), "target"));
    }

    public void implement() {

        Value sb = new Value(StringBuffer.class, "sb");
		_implementor.declare(sb, new Call(StringBuffer.class));

		DataStructField field = null;
		Value value = null;
		for(int i = 0; i < _definition.getFieldCount(); i++){
			if(i != 0){
			    _implementor.addLine("sb.append(\",\");");
			}
			field = _definition.getField(i);
			value = field.getValue();
//			_implementor.addLine("sb.append(\"" + value.getName() + ":\" + " + createGetterCall(value).toString() + ");");
			_implementor.addStatement(createAppendReceiver(value));
		}
		_implementor.addReturn("new String(sb)");
	}
	
	private Receiver createAppendReceiver(Value value) {
	    Receiver result = new Receiver("sb");
	    Call append = result.call("append");
	    Statement s = new StringLiteral(value.getName() + ":");
	    s.join("+", createGetterCall(value));
	    append.addArgument(s);
	    return result;
	}
	
	private Receiver createGetterCall(Value value) {
	    Receiver result = new Receiver("target");
	    result.call(ReadAccessor.createName(value.getName()));
	    return result;
	}
}
