/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct;

import blanco.ig.expander.NameAdjuster;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class StateAccessor extends MethodExpander {
	private Value _fieldValue = null;

	public StateAccessor(Value fieldValue) {
		super(createName(fieldValue));
		_fieldValue = fieldValue;
	}
	
	public static String createName(Value value) {
	    return MethodExpander.createName("is", value.getName());
	}

	public StateAccessor(String verv, Value fieldValue) {
		super(MethodExpander.createName(verv, fieldValue.getName()));
		_fieldValue = fieldValue;
	}

    public void setupSignature() {
        setReturnType(new Type(boolean.class));
    }

	public void implement() {
	    NameAdjuster nt = new NameAdjuster();
	    Implementor i = new Implementor(getData());

		String statement = "";
		if(_fieldValue.getType().isPrimitive()) {
		    statement = nt.toFieldName(_fieldValue.getName()) + " == false";
		} else if(_fieldValue.getType().getFullName().equals("java.lang.String")) {
		    statement = nt.toFieldName(_fieldValue.getName()) + ".equals(\"false\")";
		} else {
		    statement = nt.toFieldName(_fieldValue.getName());
		}
		i.addReturn(statement);
	}
}
