/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct;

import java.util.Iterator;

import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.method.MethodExpander;

public class GetListIteratorMethod extends MethodExpander {
	private String _name = "";

    public GetListIteratorMethod(String name) {
        super(createName(name));
		_name = name;
    }
	
	public static String createName(String name) {
		return getNameAdjuster().getMethodName("get", name + "Iterator");
	}

    public void setupSignature() {
		setReturnType(new Type(Iterator.class));
    }

    public void implement() {
		Implementor implementor = new Implementor(getData());
		
		Receiver r = new Receiver(getField(_name), "iterator");
		implementor.addReturn(r);
    }
}
