/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.core.datastruct;

import java.util.ArrayList;

import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.field.PrivateField;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.method.Constructor;

/**
 * @author Yasuo Nakanishi
 */
public class DataStructClass extends ClassExpander {
    private DataStructDefinition _definition = null;

	public DataStructClass(Type type) {
		super(type);
		_definition = new DataStructDefinition(type.getName());
	}

	public DataStructClass(Type type, DataStructDefinition definition) {
		super(type);
		_definition = definition;
	}
	
	public DataStructDefinition getDefinition() {
	    return _definition;
	}
	
    private void expandValues() {
		DataStructField field = null;
		for(int i = 0; i < _definition.getFieldCount(); i++) {
		    field = _definition.getField(i);
		    expandValue(field);
		}
    }

    protected void expandConstructors() {
		Value[] values = null;
		for(int i = 0; i < _definition.getConstructorCount(); i++) {
		    values = _definition.getConstructValues(i);
		    addMethod(createConstructor(getType().getName(), values));
		}
		    
	}
	
    protected Constructor createConstructor(String name, Value[] values) {
	    Constructor result = new DataStructConstructor(name, values);
	    for(int i = 0; i < values.length; i++) {
	        result.addArgument(values[i]);
	    }
	    return result;
	}

	public void addValue(DataStructField field) {
	    _definition.addField(field);
	}

	protected void addValue(Value value){
	    addValue(new DataStructField(value));
	}

	protected void expandValue(DataStructField field){
	    Value value = field.getValue();
		Type type = value.getType();
        FieldExpander fieldExpander = null;
		fieldExpander = new PrivateField(value);
		if(field.hasDefault()) {
			fieldExpander.setDefaultStatement(new Statement(type, field.getDefault()));
		}
		addField(fieldExpander);

		addMethod(new ReadAccessor(value));
		addMethod(new WriteAccessor(value));

		if (field.isOptional()) {
	        addMethod(new StateAccessor("has", value));
	    }
	}

	protected void expandClassStruct() {
		expandConstructors();
		expandValues();
		expandLists();
	}
	
	protected void expandLists() {
	    ListOption list = null;
	    for(int i = 0; i < _definition.getListCount(); i++) {
	        list = _definition.getList(i);
	        if(list.getListType() == ListType.ADDTIONAL_LIST) {
	            expandAddtionalList(list);
	        }
	    }
	}
	
	protected void expandAddtionalList(ListOption list) {
	    String valueName = getNameAdjuster().toValueName(list.getName(), "List");
	    String fieldName = getNameAdjuster().toFieldName(valueName);
	    Value value = new Value(ArrayList.class, valueName);

        PrivateField field = new PrivateField(value);
        field.setDefaultValue(ArrayList.class);
	    addField(field);
        
	    addMethod(new AddListItemMethod(list.getName(), list.getItemType()));
	    addMethod(new GetListItemMethod(list.getName(), fieldName, list.getItemType()));
	    addMethod(new GetListCountMethod(list.getName(), fieldName));
	}
}
