/*
 * blancoIg Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.web.struts.runtime.validator;

public class FormatValidation {

    public static final FormatValidation HALF_WIDTH = new FormatValidation("p");

    public static final FormatValidation FULL_WIDTH = new FormatValidation("Sp");

    public static final FormatValidation HALF_WIDTH_NUMBER = new FormatValidation(
            "p");

    public static final FormatValidation HALF_WIDTH_ALPHABET = new FormatValidation(
            "pp");

    public static final FormatValidation HALF_WIDTH_UPPER_CASE_ALPHABET = new FormatValidation(
            "pp啶");

    public static final FormatValidation HALF_WIDTH_LOWER_CASE_ALPHABET = new FormatValidation(
            "pp");

    public static final FormatValidation HALF_WIDTH_ALPHABET_NUMER = new FormatValidation(
            "pp");

    public static final FormatValidation HALF_WIDTH_ALPHABET_NUMER_SYMBOL = new FormatValidation(
            "ppL");

    public static final FormatValidation HALF_WIDTH_KATAKANA = new FormatValidation(
            "pJ^Ji");

    public static final FormatValidation FULL_WIDTH_NUMBER = new FormatValidation(
            "Spp啶");

    public static final FormatValidation FULL_WIDTH_ALPHABET = new FormatValidation(
            "Spp");

    public static final FormatValidation FULL_WIDTH_UPPER_CASE_ALPHABET = new FormatValidation(
            "Spp");

    public static final FormatValidation FULL_WIDTH_LOWER_CASE_ALPHABET = new FormatValidation(
            "Sp");

    public static final FormatValidation FULL_WIDTH_ALPHABET_NUMER = new FormatValidation(
            "Spp");

    public static final FormatValidation FULL_WIDTH_ALPHABET_NUMER_SYMBOL = new FormatValidation(
            "SppL");

    public static final FormatValidation FULL_WIDTH_HIRAGANA = new FormatValidation(
            "SpЂ炪");

    public static final FormatValidation FULL_WIDTH_KATAKANA = new FormatValidation(
            "SpJ^Ji");

    public static final FormatValidation FULL_WIDTH_HIRAGANA_KATAKANA = new FormatValidation(
            "SpЂ炪ȃJ^Ji");

    public static final FormatValidation YYYY_MM_DD = new FormatValidation(
            "N (YYYYMMDD)");

    public static final FormatValidation YY_MM_DD = new FormatValidation(
            "N (YYMMDD)");

    public static final FormatValidation MM_DD = new FormatValidation(
            " (MM/DD)");

    private String _name = "";

    private FormatValidation(String name) {
        _name = name;
    }

    public String getName() {
        return _name;
    }

    public static String nameToFieldName(String name) {
        String result = "";
        if (name.equals(HALF_WIDTH.getName())) {
            result = "HALF_WIDTH";
        } else if (name.equals(FULL_WIDTH.getName())) {
            result = "FULL_WIDTH";
        } else if (name.equals(HALF_WIDTH_NUMBER.getName())) {
            result = "HALF_WIDTH_NUMBER";
        } else if (name.equals(HALF_WIDTH_ALPHABET.getName())) {
            result = "HALF_WIDTH_ALPHABET";
        } else if (name.equals(HALF_WIDTH_UPPER_CASE_ALPHABET.getName())) {
            result = "HALF_WIDTH_UPPER_CASE_ALPHABET";
        } else if (name.equals(HALF_WIDTH_LOWER_CASE_ALPHABET.getName())) {
            result = "HALF_WIDTH_LOWER_CASE_ALPHABET";
        } else if (name.equals(HALF_WIDTH_ALPHABET_NUMER.getName())) {
            result = "HALF_WIDTH_ALPHABET_NUMER";
        } else if (name.equals(HALF_WIDTH_ALPHABET_NUMER_SYMBOL.getName())) {
            result = "HALF_WIDTH_ALPHABET_NUMER_SYMBOL";
        } else if (name.equals(HALF_WIDTH_KATAKANA.getName())) {
            result = "HALF_WIDTH_KATAKANA";
        } else if (name.equals(FULL_WIDTH_NUMBER.getName())) {
            result = "FULL_WIDTH_NUMBER";
        } else if (name.equals(FULL_WIDTH_ALPHABET.getName())) {
            result = "FULL_WIDTH_ALPHABET";
        } else if (name.equals(FULL_WIDTH_UPPER_CASE_ALPHABET.getName())) {
            result = "FULL_WIDTH_UPPER_CASE_ALPHABET";
        } else if (name.equals(FULL_WIDTH_LOWER_CASE_ALPHABET.getName())) {
            result = "FULL_WIDTH_LOWER_CASE_ALPHABET";
        } else if (name.equals(FULL_WIDTH_ALPHABET_NUMER.getName())) {
            result = "FULL_WIDTH_ALPHABET_NUMER";
        } else if (name.equals(FULL_WIDTH_ALPHABET_NUMER_SYMBOL.getName())) {
            result = "FULL_WIDTH_ALPHABET_NUMER_SYMBOL";
        } else if (name.equals(FULL_WIDTH_HIRAGANA.getName())) {
            result = "FULL_WIDTH_HIRAGANA";
        } else if (name.equals(FULL_WIDTH_KATAKANA.getName())) {
            result = "FULL_WIDTH_KATAKANA";
        } else if (name.equals(FULL_WIDTH_HIRAGANA_KATAKANA.getName())) {
            result = "FULL_WIDTH_HIRAGANA_KATAKANA";
        } else if (name.equals(YYYY_MM_DD.getName())) {
            result = "YYYY_MM_DD";
        } else if (name.equals(YY_MM_DD.getName())) {
            result = "YY_MM_DD";
        } else if (name.equals(MM_DD.getName())) {
            result = "MM_DD";
        } else {
            String message = "sȃtH[}bgn܂BtH[}bg:" + name;
            throw new RuntimeException(message);
        }
        return result;
    }

    public static String nameToMethodName(String name) {
        String result = "";
        if (name.equals(HALF_WIDTH.getName())) {
            result = "validateHalfWidth";
        } else if (name.equals(FULL_WIDTH.getName())) {
            result = "validateFullWidth";
        } else if (name.equals(HALF_WIDTH_NUMBER.getName())) {
            result = "validateHalfWidthNumber";
        } else if (name.equals(HALF_WIDTH_ALPHABET.getName())) {
            result = "validateHalfWidthAlphabet";
        } else if (name.equals(HALF_WIDTH_UPPER_CASE_ALPHABET.getName())) {
            result = "validateHalfWidthUpperCaseAlphabet";
        } else if (name.equals(HALF_WIDTH_LOWER_CASE_ALPHABET.getName())) {
            result = "validateHalfWidthLowerCaseAlphabet";
        } else if (name.equals(HALF_WIDTH_ALPHABET_NUMER.getName())) {
            result = "validateHalfWidthAlphabetNumber";
        } else if (name.equals(HALF_WIDTH_ALPHABET_NUMER_SYMBOL.getName())) {
            result = "validateHalfWidthAlphabetNumberSymbol";
        } else if (name.equals(HALF_WIDTH_KATAKANA.getName())) {
            result = "validateHalfWidthKatakana";
        } else if (name.equals(FULL_WIDTH_NUMBER.getName())) {
            result = "validateFullWidthNumber";
        } else if (name.equals(FULL_WIDTH_ALPHABET.getName())) {
            result = "validateFullWidthAlphabet";
        } else if (name.equals(FULL_WIDTH_UPPER_CASE_ALPHABET.getName())) {
            result = "validateFullWidthUpperCaseAlphabet";
        } else if (name.equals(FULL_WIDTH_LOWER_CASE_ALPHABET.getName())) {
            result = "validateFullWidthLowerCaseAlphabet";
        } else if (name.equals(FULL_WIDTH_ALPHABET_NUMER.getName())) {
            result = "validateFullWidthAlphabetNumber";
        } else if (name.equals(FULL_WIDTH_ALPHABET_NUMER_SYMBOL.getName())) {
            result = "validateFullWidthAlphabetNumberSymbol";
        } else if (name.equals(FULL_WIDTH_HIRAGANA.getName())) {
            result = "validateFullWidthHiragana";
        } else if (name.equals(FULL_WIDTH_KATAKANA.getName())) {
            result = "validateFullWidthKatakana";
        } else if (name.equals(FULL_WIDTH_HIRAGANA_KATAKANA.getName())) {
            result = "validateFullWidthHiraganaKatakana";
        } else if (name.equals(YYYY_MM_DD.getName())) {
            result = "validateYYYYMMDD";
        } else if (name.equals(YY_MM_DD.getName())) {
            result = "validateYYMMDD";
        } else if (name.equals(MM_DD.getName())) {
            result = "validateMMDD";
        } else {
            String message = "sȃtH[}bgn܂BtH[}bg:" + name;
            throw new RuntimeException(message);
        }
        return result;
    }
}
