/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.web.struts.metadata;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

import blanco.web.struts.runtime.BlancoAction;
import blanco.web.struts.runtime.BlancoDbAction;
import blanco.web.struts.runtime.DefaultActionForm;

/**
 * @author Yasuo Nakanishi
 */
public class StrutsMetadata {

    private List _pathList = new ArrayList();

    private Method _dispatchMethod = null;

    private Method _dispatchDbMethod = null;

    private String _eventParameterName = "eventId";

    private Class _formSuperClass = DefaultActionForm.class;

    public StrutsMetadata() {
        Class superClass = null;
        Class[] parameters = null;

        String name = "execute";

        try {
            superClass = BlancoAction.class;
            parameters = new Class[] { ActionMapping.class, ActionForm.class,
                    HttpServletRequest.class, HttpServletResponse.class };
            _dispatchMethod = superClass.getMethod(name, parameters);

            superClass = BlancoDbAction.class;
            parameters = new Class[] { ActionMapping.class, ActionForm.class,
                    HttpServletRequest.class, HttpServletResponse.class,
                    Connection.class };
            _dispatchDbMethod = superClass.getMethod(name, parameters);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getEventParameterName() {
        return _eventParameterName;
    }

    public void setEventParameterName(String eventParameterName) {
        _eventParameterName = eventParameterName;
    }

    public void addExcel(String path) {
        _pathList.add(path);
    }

    public Iterator getPathIterator() {
        return _pathList.iterator();
    }

    public Method getDispatchMethod() {
        return _dispatchMethod;
    }

    public void setDispatchMethod(Method dispatchMethod) {
        _dispatchMethod = dispatchMethod;
    }

    public Method getDispatchDbMethod() {
        return _dispatchDbMethod;
    }

    public void setDispatchDbMethod(Method dispatchDbMethod) {
        _dispatchDbMethod = dispatchDbMethod;
    }

    public Class getFormSuperClass() {
        return _formSuperClass;
    }

    public void setFormSuperClass(Class formSuperClass) {
        _formSuperClass = formSuperClass;
    }

}
