/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.web.struts.generator;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.core.datastruct.DataStructClass;
import blanco.ig.collector.ResourceBundleLoader;
import blanco.ig.expander.Type;
import blanco.ig.generator.Generator;
import blanco.ig.generator.ImplementGenerator;
import blanco.ig.generator.RuntimeGenerator;
import blanco.ig.service.ServiceClass;
import blanco.ig.tool.ConsolePrinter;
import blanco.web.struts.collector.ExcelFormCollector;
import blanco.web.struts.definition.StrutsDefinition;
import blanco.web.struts.definition.form.Form;
import blanco.web.struts.definition.form.FormTable;
import blanco.web.struts.expander.TypeFactory;
import blanco.web.struts.expander.action.AbstractActionClass;
import blanco.web.struts.expander.form.ActionFormClass;
import blanco.web.struts.metadata.StrutsMetadata;
import blanco.web.struts.runtime.BlancoAction;
import blanco.web.struts.runtime.BlancoDbAction;
import blanco.web.struts.runtime.DefaultActionForm;
import blanco.web.struts.runtime.validator.Validator;
import blanco.web.struts.runtime.validator.message.ErrorMessageKey;

/**
 * @author Yasuo Nakanishi
 */
public class StrutsGenerator implements Generator {
    private StrutsSetting _setting = null;

    private StrutsSetting _formSetting = null;

    private ServiceClass _serviceClass = new ServiceClass("Struts");

    private ImplementGenerator _ig = null;

    private ExcelFormCollector _collector = null;

    private StrutsDefinition _definition = null;

    private StrutsMetadata _metadata = null;

    private TypeFactory _typeFactory = null;

    private List _runtimeSourceDirectories = new ArrayList();

    public StrutsGenerator(StrutsSetting setting) {
        _setting = setting;
        _ig = new ImplementGenerator(_serviceClass, _setting);
        _typeFactory = new TypeFactory(_setting);
        _collector = new ExcelFormCollector(_setting);
    }

    public void setMetadata(StrutsMetadata metadata) throws Exception {
        _metadata = metadata;
    }

    public void generate(StrutsMetadata metadata) throws Exception {
        assert metadata != null;
        _metadata = metadata;
        generate();
    }

    public void addForm(Form form) {
        _ig.addMain(createForm(form));
    }

    private void collect() throws Exception {

        Iterator i = null;
        i = _metadata.getPathIterator();
        while (i.hasNext()) {
            _collector.addFormFile((String) i.next());
        }
        _definition = _collector.collect();
    }

    private void setupEpanders() {
        Iterator formIterator = null;
        Iterator tableIterator = null;

        formIterator = _definition.getFormIterator();
        Form f = null;
        while (formIterator.hasNext()) {
            f = (Form) formIterator.next();
            _ig.addMain(createForm(f));

            tableIterator = f.getTableIterator();
            FormTable table = null;
            while (tableIterator.hasNext()) {
                table = (FormTable) tableIterator.next();
                _ig.addMain(createTableItem(table));
            }
        }

        formIterator = _definition.getFormIterator();
        Iterator eventIterator = null;
        Type type = null;
        Type formType = null;
        Method method = _metadata.getDispatchMethod();
        while (formIterator.hasNext()) {
            f = (Form) formIterator.next();
            type = f.getActionType();
            // TODO AbstractCollectorɈړB
            type = new Type(type.getNameSpace(), type.getName());
            eventIterator = f.getEventIterator();
            formType = f.getType();
            _ig.addMain(new AbstractActionClass(type, _metadata, f));
        }

    }

    public void generate() throws IOException {
        // TODO generate()\bh̃VOl`B
        ConsolePrinter.get().printInfo("blancoStruts:Jn܂B");
        try {
            collect();
        } catch (Exception e) {
            e.printStackTrace();
        }
        setupEpanders();
        generateRuntime();
        generateDataStruct();
        generateMain();
        generateTest();
        ConsolePrinter.get().printInfo("blancoStruts:I܂B");
    }

    private ActionFormClass createForm(Form form) {
        ActionFormClass result = new ActionFormClass(_setting, _metadata, form);
        return result;
    }

    private DataStructClass createTableItem(FormTable table) {
        DataStructClass result = new DataStructClass(table.getType(), table);
        return result;
    }

    public void generateRuntime() throws IOException {
        RuntimeGenerator rg = new RuntimeGenerator(_setting);

        rg.addSourceDirectory("src/main");

        Iterator directories = _runtimeSourceDirectories.iterator();
        while (directories.hasNext()) {
            rg.addSourceDirectory((String) directories.next());
        }

        String path = "";
        Iterator i = _setting.getRuntimeDirectoryIterator();
        while (i.hasNext()) {
            rg.addSourceDirectory((String) i.next());
        }

        rg.addRuntime(ResourceBundleLoader.class);
        rg.addRuntime(BlancoAction.class);
        rg.addRuntime(BlancoDbAction.class);
        rg.addRuntime(DefaultActionForm.class);
        rg.addRuntime(Validator.class);
        rg.addRuntime(ErrorMessageKey.class);

        String target = "";
        target = _setting.getRootNameSpace() + ".runtime";
        if (target.equals(".runtime")) {
            target = "blanco.struts.runtime";
        }
        rg.addPackagePair("blanco.web.struts.runtime", target);
        rg.addPackagePair("blanco.ig.collector", target);
        rg.generate();
    }

    public void generateDataStruct() throws IOException {
        _ig.generateDataStruct();
    }

    public void generateMain() throws IOException {
        _ig.generateMain();
    }

    public void generateTest() throws IOException {
        _ig.generateTest();
    }

    public void addRuntimeSrouceDrirectory(String path) {
        _runtimeSourceDirectories.add(path);
    }
}
