/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.web.struts.expander.form;

import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.web.struts.definition.form.FieldValidation;
import blanco.web.struts.definition.form.Form;
import blanco.web.struts.definition.form.FormField;
import blanco.web.struts.definition.form.FormTable;
import blanco.web.struts.expander.TypeFactory;
import blanco.web.struts.expander.form.base.BaseValidationMethod;
import blanco.web.struts.runtime.validator.message.ErrorMessageKey;

/**
 * @author Yasuo Nakanishi
 */
public class ValidateRequiredMethod extends BaseValidationMethod {

    private Value _mappintArgument = null;

    private Value _requestArgument = null;

    public ValidateRequiredMethod(Form form, TypeFactory typeFactory) {
        super("validateRequired", form, typeFactory);
    }

    public void setupSignature() {
        super.setupSignature();

        String doc = "";

        doc = "K{͌؃\bhB";
        getJavaDoc().addLine(doc);

        doc = "validate()\bhɂĂ΂܂B";
        getJavaDoc().addLine(doc);
    }

    protected void implementFiledValidation(FormField field, Value errors) {
        FieldValidation validation = field.getValidation();
        if (validation.isCheckRequire()) {
            Type type = getRuntimeType(ErrorMessageKey.class);
            getImplementor().checkRequire(errors,
                    getField(field.getValue().getName()), field, type);
            getImplementor().emptyLine();
        }

    }

    protected void implementTableValidation(Value item, FormField field,
            Value errors) {

        boolean requiredCheck = field.getValidation().isCheckRequire();
        if (requiredCheck) {
            Type type = getRuntimeType(ErrorMessageKey.class);
            getImplementor().checkTableRequire(item, field, errors, type);
        }

        if (requiredCheck) {
            getImplementor().emptyLine();
        }
    }

    protected boolean existTableValidation(FormTable table) {
        return table.existRequireValidationField();
    }
}
