/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.web.struts.expander.form;

import java.util.Iterator;

import blanco.ig.expander.NameAdjuster;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.web.struts.definition.form.FieldValidation;
import blanco.web.struts.definition.form.FormField;
import blanco.web.struts.definition.form.FormTable;
import blanco.web.struts.expander.TypeFactory;
import blanco.web.struts.expander.form.base.BaseEventValidationMethod;
import blanco.web.struts.runtime.validator.message.ErrorMessageKey;

/**
 * @author Yasuo Nakanishi
 */
public class ValidateRequiredEventMethod extends BaseEventValidationMethod {

    public ValidateRequiredEventMethod(String event, Iterator eventFields,
            Iterator tableIterator, TypeFactory typeFactory) {
        super(createName(event), event, eventFields, tableIterator, typeFactory);
    }

    public static String createName(String event) {
        NameAdjuster na = getNameAdjuster();
        return createName("validate", "RequiredOn" + na.toTitleCase(event));
    }

    public void setupSignature() {
        super.setupSignature();

        String doc = "";

        doc = getName() + "CxgK{͌؃\bhB";
        getJavaDoc().addLine(doc);

        doc = "̃\bhActionNXĂяoĂB";
        getJavaDoc().addLine(doc);
    }

    protected void implemntFieldValidation(FormField field, Value errors) {
        Value fieldValue = getField(field.getValue().getName());

        if (field.getValidation().isCheckRequire()) {
            Type type = getRuntimeType(ErrorMessageKey.class);
            getImplementor().checkRequire(errors, fieldValue, field, type);
            getImplementor().emptyLine();
        }
    }

    protected void implementTablealidation(Value item, FormField f, Value errors) {
        FieldValidation validation = f.getValidation();

        boolean requireCheck = validation.isCheckRequire();
        if (requireCheck) {
            Type type = getRuntimeType(ErrorMessageKey.class);
            getImplementor().checkTableRequire(item, f, errors, type);
        }
    }

    protected boolean existTableValidation(String event, FormTable table) {
        return table.existEventRequireValidationField(event);
    }
}
