/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.web.struts.expander.form;

import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.web.struts.definition.form.FieldValidation;
import blanco.web.struts.definition.form.Form;
import blanco.web.struts.definition.form.FormField;
import blanco.web.struts.definition.form.FormTable;
import blanco.web.struts.expander.TypeFactory;
import blanco.web.struts.expander.form.base.BaseValidationMethod;
import blanco.web.struts.runtime.validator.message.ErrorMessageKey;

/**
 * @author Yasuo Nakanishi
 */
public class ValidateRangeMethod extends BaseValidationMethod {

    private Value _mappintArgument = null;

    private Value _requestArgument = null;

    public ValidateRangeMethod(Form form, TypeFactory typeFactory) {
        super(createName(), form, typeFactory);
    }

    public static String createName() {
        return "validateRange";
    }

    public void setupSignature() {
        super.setupSignature();

        String doc = "";

        doc = "͈͌؃\bhB";
        getJavaDoc().addLine(doc);

        doc = "validate()\bhɂĂ΂܂B";
        getJavaDoc().addLine(doc);
    }

    protected void implementFiledValidation(FormField field, Value errors) {
        Value fieldValue = getField(field.getValue().getName());

        FieldValidation validation = field.getValidation();

        Type keyType = getRuntimeType(ErrorMessageKey.class);

        boolean rangeCheck = field.getValidation().isCheckRange();
        if (rangeCheck) {
            getImplementor().checkIntRange(field, fieldValue, errors, keyType);
            getImplementor().emptyLine();
        }
    }

    protected boolean existTableValidation(FormTable table) {
        return table.existFormValidationField();
    }

    protected void implementTableValidation(Value item, FormField field,
            Value errors) {
        FieldValidation validation = field.getValidation();

        Type keyType = getRuntimeType(ErrorMessageKey.class);

        boolean rangeCheck = validation.isCheckRange();
        if (rangeCheck) {
            getImplementor().checkTableIntRange(item, field, errors, keyType);
            getImplementor().emptyLine();
        }
    }
}
